

<?php $__env->startSection('title', 'Channel Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-3">
    <div class="card">
        <div class="card-body">
            <h2 class="section-heading">Channel Management Table</h2>
            <table id="channelTable" class="display" style="width:100%">
                <thead>
                    <tr>
                        <th>Sr. No.</th>
                        <th>Channel Name</th>
                        <th>Plan Status</th>
                        <th>Plan Name</th>
                        <th>Amount</th>
                        <th>Gateway Type</th>
                        <th>Activate Date</th>
                        <th>Expire Date</th>
                        <th>Payment Status</th>

                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $dashboardData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                    <tr>
                        <td>1</td>
                        <td>
                            <?php if($data->channel_id == 1): ?>
                            Gateway
                            <?php elseif($data->channel_id == 2): ?>
                            Indiamart
                            <?php elseif($data->channel_id == 3): ?>
                            SignRequest
                            <?php else: ?>
                            Unknown
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($data->plan_status == 1): ?>
                            <span class="status-btn active1" style="color: white; background-color: green; padding: 5px 10px; border-radius: 5px;">Activate</span>
                            <?php else: ?>
                            <span class="status-btn active1" style="color: white; background-color: red; padding: 5px 10px; border-radius: 5px;">Deactivate</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($data->plan); ?></td>
                        <td><?php echo e($data->amount); ?></td>
                        <td><?php echo e($data->type); ?></td>
                        <td style="color: green; font-weight: bold;"><?php echo e($data->payment_date); ?></td>
                        <td style="color: red; font-weight: bold;"><?php echo e($data->plan_expire); ?></td>
                        <td>
                            <?php if($data->status == 'captured' || $data->status == 'trial'): ?>
                            <button class="btn btn-success btn-sm" style="font-size: 12px;"><?php echo e(ucfirst($data->status)); ?></button>
                            <?php else: ?>
                            <button class="btn btn-danger btn-sm" style="font-size: 12px;"><?php echo e(ucfirst($data->status)); ?></button>
                            <?php endif; ?>
                        </td>

                    </tr>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center">No data available.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Include Font Awesome for icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" />

<style>

</style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('#channelTable').DataTable({
            "paging": true,
            "info": true,
            "searching": true
        });
    });

    
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('user-dashboard.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\user_dashboard\user_dashboard\resources\views/user-dashboard/user_dashboard.blade.php ENDPATH**/ ?>