<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Register</title>
    <link rel="stylesheet" href="<?php echo e(asset('assets/login_reg_css/style.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <!-- Back Arrow -->
    <div class="back-arrow">
        <a href="<?php echo e(url('admin/team_member')); ?>" class="back-link"><span>Back</span><i class="fas fa-arrow-left"></i> </a>
    </div>

    <div class="container">
        <div class="curved-shape"></div>
        <div class="curved-shape2"></div>
        <div class="form-box Register">
            <h2 class="animation" style="--li:17; --S:0">Register</h2>
            <form action="<?php echo e(route('admin.register')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="input-box animation" style="--li:18; --S:1">
                    <input type="text" name="username" required value="<?php echo e(old('username')); ?>">
                    <label for="">Username</label>
                    <box-icon type='solid' name='user'></box-icon>
                    <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="input-box animation" style="--li:19; --S:2">
                    <input type="email" name="email" required value="<?php echo e(old('email')); ?>">
                    <label for="">Email</label>
                    <box-icon name='envelope' type='solid'></box-icon>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="input-box animation" style="--li:19; --S:3">
                    <input type="password" name="password" required>
                    <label for="">Password</label>
                    <box-icon name='lock-alt' type='solid'></box-icon>
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="input-box animation" style="--li:19; --S:3">
                    <input type="password" name="password_confirmation" required>
                    <label for="">Confirm Password</label>
                    <box-icon name='lock-alt' type='solid'></box-icon>
                </div>

                <div class="input-box animation" style="--li:20; --S:4">
                    <button class="btn" type="submit">Register</button>
                </div>

                <div class="regi-link animation" style="--li:21; --S:5">
                    <p>Already have an account? <br> <a href="<?php echo e(route('admin.login')); ?>" class="SignInLink">Sign In</a></p>
                </div>
            </form>
        </div>

        <div class="info-content Register">
            <h2 class="animation" style="--li:17; --S:0">WELCOME!</h2>
            <p class="animation" style="--li:18; --S:1">You're just a few steps away from adding a new member to the team. Please complete the form to register the new employee.</p>
        </div>
    </div>

    <style>
       
    </style>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\user_dashboard\user_dashboard\resources\views/admin-dashboard/admin_register.blade.php ENDPATH**/ ?>