

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<style>
    .custom-menu-list {
        list-style: none;
        padding: 0;
        margin: 0;
        display: flex;
        gap: 10px;
    }

    .custom-navbar {
        background-color: #f3f3f3;
        padding: 10px;
        border-radius: 5px;
        width: fit-content;
        margin: 0 auto;
    }

    .custom-menu-item {
        padding: 8px 16px;
        background-color: #ffffff;
        border: 1px solid #ddd;
        cursor: pointer;
        transition: background-color 0.3s ease;
        font-size: 16px;
        color: #333;
        border-radius: 5px;
    }

    .custom-menu-item-active {
        background-color: #4CAF50;
        color: white;
        font-weight: bold;
    }

    .custom-menu-item:hover {
        background-color: #4CAF50;
        color: white;
    }

    .content-area {
        display: flex;
        flex-direction: column;
        width: 100%;
        max-width: 1200px;
    }

    .content-heading {
        font-size: 2rem;
        font-weight: 700;
        color: #5bc0de;
        margin-bottom: 20px;
        text-align: center;
    }

    .subscription-card-grid {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 20px;
    }

    .subscription-card {
        background-color: #ffffff;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s ease;
        padding: 15px;
        overflow: hidden;
        text-align: center;
    }

    .subscription-card:hover {
        transform: translateY(-5px);
    }

    .subscription-card-header {
        font-size: 1.4rem;
        font-weight: 700;
        color: #fff;
        padding: 10px;
        background-color: #007bff;
        border-radius: 5px 5px 0 0;
    }

    .subscription-card-body {
        padding: 10px;
    }

    .subscription-card-body p {
        color: #444;
        font-size: 0.95rem;
        margin-bottom: 10px;
    }

    .subscription-card-footer {
        padding: 10px;
        background-color: #f0f0f0;
        text-align: center;
    }

    .subscription-btn {
        padding: 4px 4px 8px 4px;
        font-size: 0.75rem;
        border: none;
        border-radius: 4px;
        color: #fff;
        cursor: pointer;
        transition: background-color 0.3s ease;
        background-color: #dc3545;
    }

    .subscription-btn.subscribed {
        background-color: #28a745;
    }

    .subscription-btn:hover {
        opacity: 0.85;
    }

    .subscription-expiry-date {
        display: none;
        margin-top: 10px;
        color: #dc3545;
        font-size: 0.9rem;
    }

    .price-section {
        font-size: 1rem;
        font-weight: bold;
        color: #007bff;
        margin-top: 10px;
    }
</style>

<div class="container mt-5">
    <div class="card text-center p-4">
        <h2 class="section-heading">Subscription Plans</h2>
        <div class="custom-navbar">
            <ul class="custom-menu-list">
                <li class="custom-menu-item custom-menu-item-active" onclick="showPlan('gateway')">Gateway</li>
                <li class="custom-menu-item" onclick="showPlan('razorpay')">Razorpay</li>
                <li class="custom-menu-item" onclick="showPlan('paypal')">PayPal</li>
            </ul>
        </div>
        <div class="content-area">
            <div class="subscription-card-grid" id="cardGrid">
                <!-- Free Plan -->
                <div class="subscription-card" data-platform="gateway" data-card="card0" data-name="trial">
                    <div class="subscription-card-header">Free Plan</div>
                    <div class="subscription-card-body">
                        <p>Basic features access</p>
                        <p>Limited support</p>
                        <p>1 project</p>
                        <div class="price-section">Free<span class="pr">0</span> / 3 days</div>
                    </div>
                    <div class="subscription-card-footer">
                        <button class="subscription-btn free" id="btn-free">Subscribe</button>
                        <div class="subscription-expiry-date free-ex">Expires on: <span class="expiry">2024-12-31</span></div>

                    </div>
                
                </div>
                <!-- Silver Plan -->
                <div class="subscription-card" data-platform="gateway" data-card="card1" data-name="silver">
                    <div class="subscription-card-header">Silver Plan</div>
                    <div class="subscription-card-body">
                        <p>Standard feature access</p>
                        <p>Priority support</p>
                        <p>5 projects</p>
                        <div class="price-section">₹<span class="pr">5</span> / Month</div>
                    </div>
                    <div class="subscription-card-footer">
                        <button class="subscription-btn checkoutButton" data-card="card1">Subscribe</button>
                        <div class="subscription-expiry-date">Expires on: <span class="expiry">2024-12-31</span></div>

                    </div>
                
                </div>
                <!-- Gold Plan -->
                <div class="subscription-card" data-platform="gateway" data-card="card1" data-name="gold">
                    <div class="subscription-card-header">Gold Plan</div>
                    <div class="subscription-card-body">
                        <p>Premium feature access</p>
                        <p>24/7 support</p>
                        <p>10 projects</p>
                        <div class="price-section">₹<span class="pr">10</span> / 3-Month</div>
                    </div>
                    <div class="subscription-card-footer">
                        <button class="subscription-btn checkoutButton" data-card="card2">Subscribe</button>
                        <div class="subscription-expiry-date">Expires on: <span class="expiry">2024-12-31</span></div>

                    </div>
                </div>
                <!-- Platinum Plan -->
                <div class="subscription-card" data-platform="gateway" data-card="card1" data-name="platinum">
                    <div class="subscription-card-header">Platinum Plan</div>
                    <div class="subscription-card-body">
                        <p>All feature access</p>
                        <p>Priority support</p>
                        <p>Unlimited projects</p>
                        <div class="price-section">₹<span class="pr">20</span> / year</div>
                    </div>
                    <div class="subscription-card-footer">
                        <button class="subscription-btn checkoutButton" data-card="card3">Subscribe</button>

                        <div class="subscription-expiry-date">Expires on: <span class="expiry">2024-12-31</span></div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>

<script>
    $(document).ready(function() {
        $('#btn-free').click(function() {
            $(this).text('Wait...').prop('disabled', true);
            $.ajax({
                type: "POST",
                url: "<?php echo e(url('user/free_plan')); ?>",
                data: {
                    freeCard: $(this).val(),
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(response) {
                    console.log(response);
                    $('#btn-free').hide();
                },
                error: function(error) {
                    console.error("Error:", error);
                }
            });
        });
        // Show Plan
        function showPlan(platform) {
            $('.subscription-card').each(function() {
                if ($(this).data('platform') === platform) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
            // Set active state for menu item
            $('.custom-menu-item').removeClass('custom-menu-item-active');
            $(`.custom-menu-item:contains(${platform})`).addClass('custom-menu-item-active');
        }

        // Event listener for subscription button
        $('.checkoutButton').click(function() {
            let cardId = $(this).data("card");
            let card = $(this).closest('.subscription-card');
            let cardAmountText = card.find('.pr').text();
            let cardAmount = parseInt(cardAmountText.replace(/[^\d]/g, ''));
            let durationText = cardAmountText.match(/(days|Month|year|month)/i);
            let multiplier = 1;

            if (durationText) {
                switch (durationText[0].toLowerCase()) {
                    case '3 days':
                        multiplier = 1;
                        break;
                    case 'month':
                        multiplier = 1;
                        break;
                    case '3 month':
                        multiplier = 3;
                        break;
                    case 'year':
                        multiplier = 12;
                        break;
                }
            }

            let finalAmount = cardAmount * multiplier * 100;
            let planValue = "";

            switch (cardId) {
                case "card1":
                    planValue = 'silver';
                    break;
                case "card2":
                    planValue = 'gold';
                    break;
                case "card3":
                    planValue = 'platinum';
                    break;
            }

            // Initiate payment
            $.ajax({
                url: '<?php echo e(url("user/payment")); ?>',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify({
                    amount: finalAmount,
                    currency: 'INR',
                    payment_capture: 1,
                    _token: '<?php echo e(csrf_token()); ?>'
                }),
                success: function(data) {
                    let parsedData = JSON.parse(data);
                    let options = {
                        key: 'rzp_test_AVZSZDNOXb9CLy',
                        amount: parsedData.amount,
                        currency: parsedData.currency,
                        description: 'Subscription Plan Payment',
                        order_id: parsedData.order_id,
                        handler: function(response) {
                            $.ajax({
                                url: '<?php echo e(url("user/payment/status")); ?>',
                                type: 'POST',
                                dataType: 'json',
                                data: {
                                    payment_id: response.razorpay_payment_id,
                                    order_id: response.razorpay_order_id,
                                    customer_id: parsedData.customer_id,
                                    planValue,
                                    _token: '<?php echo e(csrf_token()); ?>'
                                },
                                success: function(response) {
                                    console.log('Payment status updated:', response);
                                    updateSubscriptionStatus(); // Update subscription status after payment
                                },
                                error: function(error) {
                                    console.error('Error updating payment status:', error);
                                }
                            });
                        },
                        theme: {
                            color: '#F37254'
                        }
                    };
                    let rzp = new Razorpay(options);
                    rzp.open();
                }
            });
        });

        // Update Subscription Status
        function updateSubscriptionStatus() {
            $.ajax({
                url: '<?php echo e(url("user/plan_status")); ?>',
                type: 'GET',
                success: function(response) {
                    console.log('Subscription status response:', response);

                    if (response.data && response.data.plan_name && response.data.expire) {
                        let planName = response.data.plan_name;
                        let expireDate = response.data.expire;
                         const date = new Date();
                        const day = String(date.getDate()).padStart(2, '0');
                        const month = String(date.getMonth() + 1).padStart(2, '0');
                        const year = date.getFullYear();
                        const hours = String(date.getHours()).padStart(2, '0');
                        const minutes = String(date.getMinutes()).padStart(2, '0');
                        const seconds = String(date.getSeconds()).padStart(2, '0');

                        let currentDate = `${day}-${month}-${year} ${hours}:${minutes}:${seconds}`;
                        $('.subscription-card').each(function() {
                            $(this).find('.subscription-expiry-date').hide();
                            $(this).find('.subscription-btn').text('Subscribe').removeClass('subscribed').css('background-color', '#dc3545').prop('disabled', false).css('cursor', 'pointer');
                        });

                        // Handle active card based on subscription status
                        let activeCard = $(`.subscription-card[data-name="${planName}"]`);
                        console.log("Active card element:", activeCard);

                        if (activeCard.length > 0 && expireDate > currentDate) {
                            // If the plan is still active
                            activeCard.find('.subscription-expiry-date').show();
                            activeCard.find('.subscription-expiry-date .expiry').text(response.data.expire);
                            activeCard.find('.subscription-btn')
                                .text('Activated')
                                .removeClass('checkoutButton')
                                .css('background-color', '#28a745') // Green for active plan
                                .prop('disabled', true) // Disable the button
                                .css('cursor', 'not-allowed'); // Change cursor to indicate disabled state
                                $('.free-ex').show();
                                $('.free-ex .expiry').text('Trial expired. Please subscribe to a paid plan.');
                                $('.free').text('Trial Expired').css('background-color', '#FFC107').prop('disabled', true).css('cursor', 'not-allowed');

                        } else if (planName === 'trial'&& expireDate < currentDate) {
                           activeCard.find('.subscription-btn').text('Trial Expired').css('background-color', '#FFC107').prop('disabled', true).css('cursor', 'not-allowed');
                           activeCard.find('.subscription-expiry-date').show();
                            activeCard.find('.subscription-expiry-date .expiry').text('Trial expired. Please subscribe to a paid plan.');
                            
                        } else {
                            console.warn('No matching active card found or plan has expired.');
                        }
                    } else {
                        console.error('Unexpected response format:', response);
                    }
                },
                error: function(error) {
                    console.error('Error fetching subscription status:', error);
                }
            });
        }

        // Initial call to set up the subscription UI
        updateSubscriptionStatus();

        // Display Razorpay plans
        showPlan('razorpay');
    });
</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('user-dashboard.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\user_dashboard\user_dashboard\resources\views/user-dashboard/subscription.blade.php ENDPATH**/ ?>