

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<style>
    .custom-menu-list {
        list-style: none;
        padding: 0;
        margin: 0;
        display: flex;
        gap: 10px;
    }

    .custom-navbar {
        background-color: #f3f3f3;
        padding: 10px;
        border-radius: 5px;
        width: fit-content;
        margin: 0 auto;
    }

    .custom-menu-item {
        padding: 8px 16px;
        background-color: #ffffff;
        border: 1px solid #ddd;
        cursor: pointer;
        transition: background-color 0.3s ease;
        font-size: 16px;
        color: #333;
        border-radius: 5px;
    }

    .custom-menu-item-active {
        background-color: #4CAF50;
        color: white;
        font-weight: bold;
    }

    .custom-menu-item:hover {
        background-color: #4CAF50;
        color: white;
    }

    .content-area {
        display: flex;
        flex-direction: column;
        width: 100%;
        max-width: 1200px;
    }

    .content-heading {
        font-size: 2rem;
        font-weight: 700;
        color: #5bc0de;
        margin-bottom: 20px;
        text-align: center;
    }

    .subscription-card-grid {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 20px;
    }

    .subscription-card {
        background-color: #ffffff;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s ease;
        padding: 15px;
        overflow: hidden;
        text-align: center;
    }

    .subscription-card:hover {
        transform: translateY(-5px);
    }

    /* Card Header */
    .subscription-card-header {
        font-size: 1.4rem;
        font-weight: 700;
        color: #fff;
        padding: 10px;
        background-color: #007bff;
        border-radius: 5px 5px 0 0;
    }

    /* Card Body */
    .subscription-card-body {
        padding: 10px;
    }

    .subscription-card-body p {
        color: #444;
        font-size: 0.95rem;
        margin-bottom: 10px;
    }

    /* Card Footer */
    .subscription-card-footer {
        padding: 10px;
        background-color: #f0f0f0;
        text-align: center;

    }

    .subscription-btn {
        padding: 4px 4px 8px 4px;
        font-size: 0.75rem;
        border: none;
        border-radius: 4px;
        color: #fff;
        cursor: pointer;
        transition: background-color 0.3s ease;
        background-color: #dc3545;
    }

    .subscription-btn.subscribed {
        background-color: #28a745;
    }

    .subscription-btn:hover {
        opacity: 0.85;
    }

    
    .subscription-expiry-date {
        display: none;
        margin-top: 10px;
        color: #dc3545;
        font-size: 0.9rem;
    }

    .price-section {
        font-size: 1rem;
        font-weight: bold;
        color: #007bff;
        margin-top: 10px;
    }
</style>

<div class="container mt-5">
    <div class="card text-center p-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="section-heading">Subscription Plans</h2>
        </div>
        <div class="custom-navbar">
            <ul class="custom-menu-list">
                <li class="custom-menu-item custom-menu-item-active" onclick="showPlan('indiamart')">IndiaMart</li>
                <li class="custom-menu-item" onclick="showPlan('razorpay')">Razorpay</li>
                <li class="custom-menu-item" onclick="showPlan('paypal')">PayPal</li>
            </ul>
        </div>
        <div class="content-area">
            <div class="subscription-card-grid" id="cardGrid">
                <!-- Subscription Cards -->
                <div class="subscription-card" data-platform="indiamart">
                    <div class="subscription-card-header">Free Plan</div>
                    <div class="subscription-card-body">
                        <p>Basic features access</p>
                        <p>Limited support</p>
                        <p>1 project</p>
                        <div class="price-section">₹2 / month</div>
                    </div>
                    <div class="subscription-card-footer">
                        <button class="subscription-btn" onclick="subscribe(this, 'Free')">Subscribe</button>
                        <div class="subscription-expiry-date">Expires on: <span class="expiry">2024-12-31</span></div>
                    </div>
                </div>

                <div class="subscription-card" data-platform="indiamart">
                    <div class="subscription-card-header">Silver Plan</div>
                    <div class="subscription-card-body">
                        <p>Standard feature access</p>
                        <p>Priority support</p>
                        <p>5 projects</p>
                        <div class="price-section">₹5 / month</div>
                    </div>
                    <div class="subscription-card-footer">
                        <button class="subscription-btn" onclick="subscribe(this, 'Silver')">Subscribe</button>
                        <div class="subscription-expiry-date">Expires on: <span class="expiry">2024-12-31</span></div>
                    </div>
                </div>

                <div class="subscription-card" data-platform="indiamart">
                    <div class="subscription-card-header">Gold Plan</div>
                    <div class="subscription-card-body">
                        <p>Advanced feature access</p>
                        <p>Premium support</p>
                        <p>Unlimited projects</p>
                        <div class="price-section">₹10 / month</div>
                    </div>
                    <div class="subscription-card-footer">
                        <button class="subscription-btn" onclick="subscribe(this, 'Gold')">Subscribe</button>
                        <div class="subscription-expiry-date">Expires on: <span class="expiry">2024-12-31</span></div>
                    </div>
                </div>

                <div class="subscription-card" data-platform="indiamart">
                    <div class="subscription-card-header">Platinum Plan</div>
                    <div class="subscription-card-body">
                        <p>All features unlocked</p>
                        <p>24/7 support</p>
                        <p>Unlimited projects</p>
                        <div class="price-section">₹20 / month</div>
                    </div>
                    <div class="subscription-card-footer">
                        <button class="subscription-btn" onclick="subscribe(this, 'Platinum')">Subscribe</button>
                        <div class="subscription-expiry-date">Expires on: <span class="expiry">2024-12-31</span></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('user-dashboard.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\user_dashboard\resources\views/user-dashboard/subscription.blade.php ENDPATH**/ ?>