

<?php $__env->startSection('title', 'Channel Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-3">
    <div class="card">
        <div class="card-body">
            <h2 class="section-heading">Channel Management Table</h2>
            <table id="channelTable" class="display" style="width:100%">
                <thead>
                    <tr>
                        <th>Sr. No.</th>
                        <th>Channel Name</th>
                        <th>Status</th>
                        <th>Action</th>
                        <th>Subscription</th>
                        <th>Expire Date</th>
                        <th>Activate Date</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>1</td>
                        <td>Channel 1</td>
                        <td><span class="status-btn active1">Active</span></td>
                        <td>
                            <button class="btn-action edit-btn"><i class="fas fa-edit"></i></button>
                            <button class="btn-action delete-btn"><i class="fas fa-trash-alt"></i></button>
                        </td>
                        <td>Premium</td>
                        <td>2024-12-31</td>
                        <td>2023-01-01</td>
                    </tr>
                    <tr>
                        <td>2</td>
                        <td>Channel 2</td>
                        <td><span class="status-btn inactive">Inactive</span></td>
                        <td>
                            <button class="btn-action edit-btn"><i class="fas fa-edit"></i></button>
                            <button class="btn-action delete-btn"><i class="fas fa-trash-alt"></i></button>
                        </td>
                        <td>Basic</td>
                        <td>2024-05-15</td>
                        <td>2023-03-20</td>
                    </tr>
                    <!-- Add more rows as needed -->
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Include Font Awesome for icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" />

<style>
   
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('#channelTable').DataTable({
            "paging": true,
            "info": true,
            "searching": true
        });
    });

    function activateChannel(srNo) {
        alert(`Activating channel with Sr. No.: ${srNo}`);
        // Add AJAX or logic here for activating the channel
    }

    function deactivateChannel(srNo) {
        alert(`Deactivating channel with Sr. No.: ${srNo}`);
        // Add AJAX or logic here for deactivating the channel
    }
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user-dashboard.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\user_dashboard\resources\views/user-dashboard/user_dashboard.blade.php ENDPATH**/ ?>