<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\AdminRegisterController;
use App\Http\Controllers\Auth\AdminLoginController;
use App\Http\Controllers\UsersControlle;
use App\Http\Controllers\Users\ChannelController;
use App\Http\Controllers\PaymentsController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Admin routes
    
Route::group(['prefix' => 'admin', 'middleware' => 'admin'], function () {
  Route::get('dashboard', function () {
      return view('admin-dashboard/dashboard');
  })->name('admin.dashboard');

  Route::post('logout', [AdminLoginController::class, 'logout'])->name('admin.logout');
  Route::get('team_member', [AdminRegisterController::class, 'teamDataShow']);
  Route::get('register', [AdminRegisterController::class, 'showRegistrationForm'])->name('admin.register');
  Route::post('register', [AdminRegisterController::class, 'register']);
  Route::get('dashboard', function () {
    return view('admin-dashboard/dashboard');
})->name('admin.dashboard');

});
      Route::prefix('admin')->group(function () {
    Route::get('login', [AdminLoginController::class, 'showLoginForm'])->name('admin.login');
    Route::post('login', [AdminLoginController::class, 'login']);

    
    Route::get('team_member', [AdminRegisterController::class, 'teamDataShow']);
    Route::get('register', [AdminRegisterController::class, 'showRegistrationForm'])->name('admin.register');
    Route::post('register', [AdminRegisterController::class, 'register']);
  

});


// Frontend routes
Route::get('/', function () {
    return view('front-end/welcome');
});
Route::get('contact', function () {
    return view('front-end/contact');
});
Route::get('about', function () {
    return view('front-end/about');
});
Route::get('price', function () {
    return view('front-end/price');
});
Route::get('terms', function () {
    return view('front-end/terms');
});
Route::get('agreement', function () {
    return view('front-end/agreement');
});
Route::get('privacy', function () {
    return view('front-end/privacy');
});

/*  Route::get('login', function () {
    return view('front-end/login');
});

Route::get('register', function () {
    return view('front-end/register');
});
Route::get('dashboard', function () {
    return view('user-dashboard/user_dashboard');
});*/
/*Route::get('channels', function () {
    return view('user-dashboard/all-channels');
});
Route::get('subscription', function () {
    return view('user-dashboard/subscription');
});*/
 Route::get('test',[ChannelController::class,'index']);
//users login route //
Route::get('login', [UsersControlle::class, 'showLoginForm'])->name('login');
Route::post('login', [UsersControlle::class, 'login']);
Route::post('logout', [UsersControlle::class, 'logout'])->name('logout');
Route::get('register', [UsersControlle::class, 'showRegistrationForm'])->name('register');
Route::post('register', [UsersControlle::class, 'register']);

Route::middleware(['auth'])->prefix('user')->group(function () {
    Route::get('dashboard',[UsersControlle::class,'show_channels'])->name('user.dashboard');
    /*Route::get('dashboard', function () {
        return view('user-dashboard.user_dashboard');
    })->name('user.dashboard');*/
    Route::post('add_channel', [ChannelController::class, 'updateChannel']);
//Route::put('/updateChannel', [ChannelController::class, 'updateChannel']);
Route::get('url-get', [ChannelController::class,'url_get']);


Route::get('channels', function () {
    return view('user-dashboard/all-channels');
});
Route::get('subscription', function () {
    return view('user-dashboard/subscription');
});
Route::post('payment',[PaymentsController::class,'index']);
    Route::post('payment.add',[PaymentsController::class,'payment']);
    Route::post('/payment/status', [PaymentsController::class, 'getPaymentStatus']);
    Route::get('plan', [PaymentsController::class, 'plan']);
    Route::get('plan_status', [PaymentsController::class,'plan_activate']);
    Route::post('/free_plan', [PaymentsController::class,'free_plan']);
    Route::get('plan_status', [PaymentsController::class,'plan_activate']);


});


