@extends('user-dashboard.layouts.app')

@section('title', 'Channel Management')

@section('content')
<div class="container py-3">
    <div class="card">
        <div class="card-body">
            <h2 class="section-heading">Channel Management Table</h2>
            <table id="channelTable" class="display" style="width:100%">
                <thead>
                    <tr>
                        <th>Sr. No.</th>
                        <th>Channel Name</th>
                        <th>Plan Status</th>
                        <th>Plan Name</th>
                        <th>Amount</th>
                        <th>Gateway Type</th>
                        <th>Activate Date</th>
                        <th>Expire Date</th>
                        <th>Payment Status</th>

                    </tr>
                </thead>
                <tbody>
                    @forelse($dashboardData as $data)

                    <tr>
                        <td>1</td>
                        <td>
                            @if ($data->channel_id == 1)
                            Gateway
                            @elseif ($data->channel_id == 2)
                            Indiamart
                            @elseif ($data->channel_id == 3)
                            SignRequest
                            @else
                            Unknown
                            @endif
                        </td>
                        <td>
                            @if ($data->plan_status == 1)
                            <span class="status-btn active1" style="color: white; background-color: green; padding: 5px 10px; border-radius: 5px;">Activate</span>
                            @else
                            <span class="status-btn active1" style="color: white; background-color: red; padding: 5px 10px; border-radius: 5px;">Deactivate</span>
                            @endif
                        </td>
                        <td>{{ $data->plan }}</td>
                        <td>{{ $data->amount }}</td>
                        <td>{{ $data->type }}</td>
                        <td style="color: green; font-weight: bold;">{{ $data->payment_date }}</td>
                        <td style="color: red; font-weight: bold;">{{ $data->plan_expire }}</td>
                        <td>
                            @if ($data->status == 'captured' || $data->status == 'trial')
                            <button class="btn btn-success btn-sm" style="font-size: 12px;">{{ ucfirst($data->status) }}</button>
                            @else
                            <button class="btn btn-danger btn-sm" style="font-size: 12px;">{{ ucfirst($data->status) }}</button>
                            @endif
                        </td>

                    </tr>

                    @empty
                    <tr>
                        <td colspan="7" class="text-center">No data available.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Include Font Awesome for icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" />

<style>

</style>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('#channelTable').DataTable({
            "paging": true,
            "info": true,
            "searching": true
        });
    });

    
</script>
@endpush