<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>@yield('title', 'Dashboard')</title>
    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('assets/img/favicon/favicon.ico') }}" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ asset('assets/user_dashboard_assets/assets/vendor/css/core.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/user_dashboard_assets/assets/vendor/css/theme-default.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/user_dashboard_assets/assets/css/demo.css') }}" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ asset('assets/user_dashboard_assets/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/user_dashboard_assets/assets/vendor/libs/apex-charts/apex-charts.css') }}" />
    <!-- jQuery DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">

    <!-- Page Specific CSS -->
    @stack('styles')

    <!-- Helper JS -->
    <script src="{{ asset('assets/user_dashboard_assets/assets/vendor/js/helpers.js') }}"></script>
    <script src="{{ asset('assets/user_dashboard_assets/assets/js/config.js') }}"></script>
</head>
<body>
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Sidebar -->
            @include('user-dashboard.layouts.sidebar')
            
            <!-- Layout Container -->
            <div class="layout-page">
                <!-- Navbar -->
                @include('user-dashboard.layouts.navbar')

                <!-- Content Wrapper -->
                <div class="content-wrapper">
                    <!-- Main Content -->
                    @yield('content')

                    <!-- Footer -->
                    @include('user-dashboard.layouts.footer')
                </div>
            </div>
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>

    <!-- Core JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="{{ asset('assets/user_dashboard_assets/assets/vendor/libs/popper/popper.js') }}"></script>
    <script src="{{ asset('assets/user_dashboard_assets/assets/vendor/js/bootstrap.js') }}"></script>
    <script src="{{ asset('assets/user_dashboard_assets/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js') }}"></script>
    <script src="{{ asset('assets/user_dashboard_assets/assets/vendor/js/menu.js') }}"></script>

    <!-- Vendors JS -->
    <script src="{{ asset('assets/user_dashboard_assets/assets/vendor/libs/apex-charts/apexcharts.js') }}"></script>

    <!-- Main JS -->
    <script src="{{ asset('assets/user_dashboard_assets/assets/js/main.js') }}"></script>
    
    <!-- Page JS -->
    <script src="{{ asset('assets/user_dashboard_assets/assets/js/dashboards-analytics.js') }}"></script>
    <!-- jQuery DataTables JS -->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

    <!-- Additional Scripts -->
    @stack('scripts')
</body>
</html>
