@extends('user-dashboard.layouts.app')

@section('title', 'Dashboard')

@section('content')
<div class="container mt-5">
    <div class="card text-center p-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="section-heading">All Channels</h2>
        </div>

        <div class="row g-4" id="all-channels">
            <!-- Channel Cards with Data Attributes -->
            <div class="col-md-3 channel-column">
                <div class="channel-card" onclick="openAddChannelModal(this)" data-channel="Gateway"data-urlgateway="hamid.com" data-id="1" data-logo="https://media.tradly.app/images/marketplace/34521/razor_pay_icon-ICtywSbN.png">
                    <img src="https://banner2.cleanpng.com/20180424/vpe/aveq2gs0b.webp" alt="Gateway Logo" class="channel-logo">
                    <div class="channel-name">Gateway</div>

                    <div class="connected-icon">
                        <img src="https://www.pngkit.com/png/full/12-120360_check-mark-right-and-wrong-signs-png.png" alt="Connected" />
                    </div>
                </div>
            </div>
            <div class="col-md-3 channel-column">
                <div class="channel-card" onclick="openAddChannelModal(this)" data-channel="Indiamart" data-id="2" data-logo="https://i1.wp.com/techstory.in/wp-content/uploads/2015/07/Indiamart.jpg">
                    <img src="https://i1.wp.com/techstory.in/wp-content/uploads/2015/07/Indiamart.jpg" alt="Indiamart Logo" class="channel-logo">
                    <div class="channel-name">Indiamart</div>
                    <div class="connected-icon">
                        <img src="https://www.pngkit.com/png/full/12-120360_check-mark-right-and-wrong-signs-png.png" alt="Connected" />
                    </div>
                </div>
            </div>
            <div class="col-md-3 channel-column">
                <div class="channel-card" onclick="openAddChannelModal(this)" data-channel="PayPal" data-id="3" data-logo="https://static.vecteezy.com/system/resources/previews/009/469/637/original/paypal-payment-icon-editorial-logo-free-vector.jpg">
                    <img src="https://static.vecteezy.com/system/resources/previews/009/469/637/original/paypal-payment-icon-editorial-logo-free-vector.jpg" alt="PayPal Logo" class="channel-logo">
                    <div class="channel-name">PayPal</div>
                    <div class="connected-icon">
                        <img src="https://www.pngkit.com/png/full/12-120360_check-mark-right-and-wrong-signs-png.png" alt="Connected" />
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for adding a channel -->
<div id="addChannelModal" class="custom-modal">
    <div class="modal-content">
        <span class="close-btn" onclick="closeAddChannelModal()">&times;</span>
        <h2 id="modalTitle">Add Channel</h2>
        <p id="selectedChannelName">Channel Name</p>
        <input type="hidden" id="channelId" name="channelId">
        <label for="bitrix24Url">Bitrix24 URL</label>
        <input type="text" id="bitrix24Url" name="bitrix24Url" placeholder="Enter Bitrix24 URL" class="modal-input">
        <button id="connectChannelBtn">Connect Channel</button>
    </div>
</div>
@endsection

@push('styles')
<style>
    /* Custom styles for modal */
    .custom-modal {
        display: none;
        position: fixed;
        z-index: 1050;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
        justify-content: center;
        align-items: center;
    }

    .modal-content {
        background-color: #fff;
        padding: 20px;
        border-radius: 8px;
        max-width: 400px;
        width: 90%;
        text-align: center;
        position: relative;
    }

    .close-btn {
        position: absolute;
        top: 10px;
        right: 10px;
        font-size: 24px;
        cursor: pointer;
    }

    .modal-content h2 {
        color: #007bff;
    }

    .modal-content label {
        display: block;
        margin-top: 15px;
        font-weight: bold;
    }

    .modal-input {
        width: 100%;
        padding: 8px;
        margin-top: 5px;
        border: 1px solid #ccc;
        border-radius: 4px;
    }

    .modal-content button {
        background-color: #007bff;
        color: #fff;
        padding: 10px 20px;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        margin-top: 20px;
    }

    .modal-content button:hover {
        background-color: #0056b3;
    }

    /* Position the "Connected" icon at the top-right corner */
    .channel-card {
        position: relative;
    }

    .connected-icon {
        position: absolute;
        top: 5px; /* Adjusted position for smaller space */
        right: 5px; /* Adjusted position for smaller space */
        width: 20px; /* Smaller icon size */
        height: 20px; /* Smaller icon size */
        background-color: #4CAF50; /* Optional: Add a background color for the icon */
        border-radius: 50%;
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 3px; /* Smaller padding */
        display: none;
    }

    .connected-icon img {
        width: 100%;
        height: 100%;
        object-fit: contain;
    }
</style>
@endpush

@push('scripts')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    // Open Modal with Channel Data
    function openAddChannelModal(element) {
        $('#addChannelModal').css('display', 'flex'); // Show the modal
    const channelName = $(element).data('channel');
    const channelId = $(element).data('id');
    const bitrix24Url = $(element).data('urlgateway'); // URL for the selected channel
    $('#selectedChannelName').text(channelName);
    $('#channelId').val(channelId);
    $('#bitrix24Url').val(bitrix24Url);
    
    // Set the Bitrix24 URL in the input field
        }

    // Close Modal
    function closeAddChannelModal() {
        $('#addChannelModal').css('display', 'none');
    }

    // Add or Update Channel via AJAX
    $('#connectChannelBtn').click(function() {
        const bitrix24Url = $('#bitrix24Url').val();
        const channelId = $('#channelId').val();
    
        // Always use the same route for both adding and updating
        const url = '/user/add_channel';
        const method = 'POST'; // Since we're using the same route, we always use POST

        $.ajax({
            url: url,
            method: method,
            data: {
                _token: '{{ csrf_token() }}',
                bitrix24_url: bitrix24Url,
                channel_id: channelId, // Send the channelId in the request to differentiate the update
            },
            success: function(data) {
                if (data.success) {
                    closeAddChannelModal();
                    
                    
                }
            },
            error: function(error) {
                console.log('Error:', error);
            }
        });
    });

    $.ajax({
    type: 'GET',
    url: "{{ url('user/url-get') }}",
    success: function(data) {
        if (data.status == 'error') {
            $(".api-text2").text(data.message);
        } else {
            let channel_id = data.channel_id;
            let channel_card = $(`.channel-card[data-id="${channel_id}"]`);
            // Check if the channel card exists
            if (channel_card.length > 0 && data.channel_id == 1) {
                    channel_card.find('.connected-icon').show();
                    channel_card.attr('data-urlgateway', data.url);

                
            }
        }
    },
    error: function(error) {
        console.log(error);
    }
});

</script>
@endpush
