@extends('front-end.master-layout')
@section('title', 'User Registration')

@section('content')
<style>
    .custom-button {
        background-color: #6804e2 !important;
        border-color: #6804e2;
        color: #fff;
        transition: all 0.3s ease;
    }

    .custom-button:hover {
        background-color: #4e02b5 !important;
        border-color: #4e02b5;
    }

    .form-icon {
        color: #6804e2;
        font-size: 1.2rem;
    }

    .form-heading h2 {
        font-weight: 700;
        color: #6804e2;
    }
</style>

<div class="container py-5">
    <div class="row align-items-center">
        <!-- Left Side -->
        <div class="col-lg-5 mb-4 mb-lg-0">
            <div class="form-heading">
                <h2>Join Us</h2>
                <p class="text-muted">Register to access our exclusive services tailored to your business needs.</p>
            </div>
            <ul class="list-unstyled text-muted">
                <li><i class="bi bi-check-circle-fill text-success me-2"></i> Fast & Easy Setup</li>
                <li><i class="bi bi-check-circle-fill text-success me-2"></i> 24/7 Support</li>
                <li><i class="bi bi-check-circle-fill text-success me-2"></i> Secure Data</li>
            </ul>
        </div>

        <!-- Right Side Form -->
        <div class="col-lg-7">
            <div class="p-4 rounded shadow-sm bg-light">
                <form id="member-registration" action="{{ route('register') }}" method="post" enctype="multipart/form-data">
                    @csrf

                    <div class="row">
                        <div class="col-md-6 mb-3 form-floating">
                            <input type="text" class="form-control @error('name') is-invalid @enderror"
                                   id="name" name="name" placeholder="Your Name" value="{{ old('name') }}" required>
                            <label for="name">Your Name</label>
                            @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-6 mb-3 form-floating">
                            <input type="email" class="form-control @error('email') is-invalid @enderror"
                                   id="email" name="email" placeholder="Email Address" value="{{ old('email') }}" required>
                            <label for="email">Email Address</label>
                            @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3 form-floating">
                            <input type="text" class="form-control @error('phone') is-invalid @enderror"
                                   id="phone" name="phone" placeholder="Phone Number" value="{{ old('phone') }}" required>
                            <label for="phone">Phone Number</label>
                            @error('phone') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <select class="form-select @error('country') is-invalid @enderror"
                                    id="country" name="country" required>
                                <option value="">Select Country</option>
                                @foreach(['United States', 'Canada', 'United Kingdom', 'India', 'Germany', 'Japan', 'Australia', 'Russia', 'Brazil', 'Spain', 'France', 'Italy', 'China'] as $country)
                                    <option value="{{ $country }}" {{ old('country') == $country ? 'selected' : '' }}>{{ $country }}</option>
                                @endforeach
                            </select>
                            @error('country') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3 form-floating">
                            <input type="text" class="form-control @error('city') is-invalid @enderror"
                                   id="city" name="city" placeholder="City" value="{{ old('city') }}" required>
                            <label for="city">City</label>
                            @error('city') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-6 mb-3 form-floating">
                            <input type="text" class="form-control" id="company" name="company"
                                   placeholder="Company Name" value="{{ old('company') }}">
                            <label for="company">Company Name</label>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3 form-floating">
                            <input type="password" class="form-control @error('password') is-invalid @enderror"
                                   id="password" name="password" placeholder="Password" required>
                            <label for="password">Password</label>
                            @error('password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-6 mb-3 form-floating">
                            <input type="password" class="form-control @error('confirm-password') is-invalid @enderror"
                                   id="confirm-password" name="confirm-password" placeholder="Confirm Password" required>
                            <label for="confirm-password">Confirm Password</label>
                            @error('confirm-password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                    </div>

                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <button type="submit" class="btn custom-button px-4">Register</button>
                        <a href="{{ url('login') }}">Already registered? Sign in</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
