@extends('admin-dashboard.layouts.app')

@section('title', 'Team Member')

@section('content')

<div class="row">
    <div class="col-12">
        <div class="card shadow-sm mb-4">
        <div class="card-header py-3 bg-primary text-white d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold">All Team Member List</h6>
        <a href="{{url('admin/register')}}" class="btn btn-light btn-sm text-primary d-flex align-items-center">
            <i class="fas fa-plus mr-2"></i> Add Team Member
</a>
    </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover text-center mb-0" id="dataTable" width="100%" cellspacing="0">
                        <thead class="thead-light">
                            <tr>
                                <th>Sr.No.</th>
                                <th>User Name</th>
                                <th>Email Id</th>
                                <th>Status</th>
                                <th>Member Add Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                             @foreach($team_members as $team_member  )
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{$team_member->username}}</td>
                                <td>{{$team_member->email}}</td>
                                <td>
                                    <button class="btn btn-success btn-sm status-btn" onclick="toggleStatus(this)">Activate</button>
                                </td>
                                <td>{{$team_member->created_at}}</td>
                                <td>
                                    <a href="#" class="btn btn-primary btn-sm"><i class="fas fa-edit"></i></a>
                                    <a href="#" class="btn btn-danger btn-sm"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                            @endforeach
                            <!-- Add more rows as needed -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection
