<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login</title>
    <link rel="stylesheet" href="{{ asset('assets/login_reg_css/style.css') }}">
</head>
<body>
    <div class="container">
        <div class="curved-shape"></div>
        <div class="curved-shape2"></div>
        <div class="form-box Login">
            <h2 class="animation" style="--D:0; --S:21"> Admin Login</h2>
            <form action="{{ route('admin.login') }}" method="POST">
                @csrf
                <div class="input-box animation" style="--D:1; --S:22">
                    <input type="text" name="email" required value="{{ old('email') }}">
                    <label for="">Email</label>
                    <box-icon type='solid' name='user'></box-icon>
                    @error('email')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>

                <div class="input-box animation" style="--D:2; --S:23">
                    <input type="password" name="password" required>
                    <label for="">Password</label>
                    <box-icon name='lock-alt' type='solid'></box-icon>
                    @error('password')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>

                <div class="input-box animation" style="--D:3; --S:24">
                    <button class="btn" type="submit">Login</button>
                </div>

                <div class="regi-link animation" style="--D:4; --S:25">
                    <p><br> Don't have an account? <br> <a href="{{ route('admin.register') }}" class="SignUpLink">Sign Up</a></p>
                </div>
            </form>
        </div>

        <div class="info-content Login">
            <h2 class="animation" style="--D:0; --S:20">WELCOME BACK!</h2>
            <p class="animation" style="--D:1; --S:21">Please log in to access your account and continue where you left off. We're glad to see you again.</p>
        </div>
    </div>
</body>
</html>
