<?php 
//app/Http/Controllers/AuthController.php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;


class UsersControlle extends Controller
{
    public function showLoginForm()
    {
        return view('front-end/login');
    }

    public function login(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        if (Auth::attempt($request->only('email', 'password'))) {
            return redirect()->route('user.dashboard');
        }

        return back()->withErrors(['email' => 'Invalid credentials.']);
    }

    public function logout()
    {
        Auth::logout();
        return redirect()->route('login');
    }

    public function showRegistrationForm()
    {
        return view('front-end/register');
    }

    public function register(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:users',
            'phone' => 'required|unique:users',
            'country' => 'required|string|max:255',
            'city' => 'required|string|max:255',
            'company' => 'nullable|string|max:255',
            'password' => 'required|min:6',
        ]);

        User::create([
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'country' => $request->country,
            'city' => $request->city,
            'company' => $request->company,
            'password' => Hash::make($request->password),
        ]);

        Auth::attempt($request->only('email', 'password'));

        return redirect()->route('user.dashboard');
    }
     function show_channels(){
        $dashboardData = DB::table('payments')
    ->join('gateway_details_table', 'payments.user_id', '=', 'gateway_details_table.user_id')
    ->select('payments.*', 'gateway_details_table.*') // Select all fields from both tables
    ->where('payments.user_id', auth()->user()->id) // Filter where user_id matches
    ->get();

        
        return view('user-dashboard.user_dashboard', compact('dashboardData'));


     }
}
