<?php

namespace App\Http\Controllers\Users;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;



class ChannelController extends Controller
{
    public function updateChannel(Request $request)
    {
        // Validate the incoming request
        $userId = Auth::id();
    
        $request->validate([
            'bitrix24_url' => 'required',
            'channel_id' => 'required', // Assuming 'channel_id' is also required
        ]);
    
        // Check if a record already exists for the given user_id
        $existingRecord = DB::table('gateway_details_table')
            ->where('user_id', $userId)
            ->first();
    
        // If the record exists, update it with the new URL and channel ID
        if ($existingRecord) {
            DB::table('gateway_details_table')
                ->where('user_id', $userId)
                ->update([
                    'bitrix24_meatch_url' => $request->input('bitrix24_url'),
                    'channel_id' => $request->input('channel_id')
                ]);
    
            return response()->json([
                'success' => true,
                'message' => 'Channel URL updated successfully.',
            ]);
        } else {
            // If the record doesn't exist, insert a new record
            DB::table('gateway_details_table')
                ->insert([
                    'user_id' => $userId,
                    'bitrix24_meatch_url' => $request->input('bitrix24_url'),
                    'channel_id' => $request->input('channel_id')
                ]);
    
            return response()->json([
                'success' => true,
                'message' => 'New channel URL added successfully.',
            ]);
        }
    }

    public function Url_get()
    {
        // Fetch the user-specific data from the database
        $u = DB::table('gateway_details_table')
            ->where('user_id', auth()->user()->id)
            ->first();
    
        // Initialize variables
        $responseData=[];    
        // Check if the record exists and assign values to $url and $channel_id
        if (!empty($u)) {
            $url = $u->bitrix24_meatch_url;
            $channel_id = $u->channel_id;
            $key = $url; // Set $key to the found URL
            $responseData = ['url' => $key,'channel_id'=>$channel_id];

        }
    
        // Prepare the response data
    
        // Return the response as JSON
        return response()->json($responseData);
    }
            

}
