@extends('front-end/master-layout')
@section('title', 'Home | price')

@section('content')
 


<div class="container mb-4">
  <div class="heading-section">
    <h1>B24APPS Pricing</h1>
    <p>Not sure where to start? Try the START plan.<br>If you need more chats, we’ll be here to help you upgrade</p>
  </div>

 <div class="d-flex justify-content-center align-items-center flex-wrap gap-4 mb-4">
  <div class="d-flex flex-wrap toggle-btns">
    <button class="btn btn-active" data-duration="1">1 month</button>
    <button class="btn btn-light" data-duration="6">6 months <span class="discount-tag">-10%</span></button>
    <button class="btn btn-light" data-duration="12">1 year <span class="discount-tag">-20%</span></button>
  </div>

  <div class="d-flex currency-btns">
    <button class="btn btn-active" data-currency="USD">$</button>
    <button class="btn btn-light" data-currency="EUR">€</button>
    <button class="btn btn-light" data-currency="INR">₹</button>
    <button class="btn btn-light" data-currency="KZT">₸</button>
  </div>
</div>
 <div class="d-flex justify-content-center flex-wrap platform-tabs mb-4 ">
  <button class="btn active me-2" data-platform="Telephony">Telephony SaaS</button>
  <button class="btn me-2" data-platform="Ticketing">Ticketing System</button>
  <button class="btn me-2" data-platform="Tally">Tally Integration</button>
  <button class="btn me-2" data-platform="Gateway">Payment Gateway</button>
  <button class="btn me-2" data-platform="Chatbot">AI Chatbot</button>
  <button class="btn me-2" data-platform="Unnofficial">Unnofficial Whatsapp</button>
  <button class="btn me-2" data-platform="Official">Official WhatsApp Bitrix</button>
  <button class="btn me-2" data-platform="Location">Location Tracking</button>
  <button class="btn me-2" data-platform="HR">HR System</button>
</div>


  <div class="row g-4" id="pricingCards"></div>
</div>

<script>
  const basePrices = {
    'Telephony': [15, 30, 45, 90],
    'Ticketing': [25, 50, 75, 120],
    'Tally': [10, 20, 30, 60],
    'Gateway': [12, 24, 36, 72],
    'Chatbot': [8, 16, 24, 48],
    'Unnofficial': [20, 40, 60, 100],
    'Official': [20, 40, 60, 100],
    'Location': [20, 40, 60, 100],
    'HR': [20, 40, 60, 100]
  };

  const labels = ['START', 'INBOX', 'PRO', 'MAX'];
  const colors = ['label-start', 'label-inbox', 'label-pro', 'label-max'];
  const features = [
    ['Can start chats', 'Number of chats', 'Group chats', 'Audio transcription'],
    [['yes','50','no','no'],['no','500','no','no'],['yes','500','yes','no'],['yes','unlimited','yes','yes']]
  ];

  const currencyRates = {
    'USD': 1,
    'EUR': 0.92,
    'INR': 83,
    'KZT': 450
  };

  let selectedPlatform = 'Telephony';
  let selectedCurrency = 'USD';
  let selectedDuration = 1;

  function updateCards() {
    const container = document.getElementById('pricingCards');
    container.innerHTML = '';
    const prices = basePrices[selectedPlatform];

    prices.forEach((price, i) => {
      let finalPrice = price * selectedDuration;
      if (selectedDuration === 6) finalPrice *= 0.9;
      if (selectedDuration === 12) finalPrice *= 0.8;
      finalPrice *= currencyRates[selectedCurrency];

      container.innerHTML += `
        <div class="col-12 col-sm-6 col-lg-3">
          <div class="price-card">
            <h5>${selectedPlatform} <span class="badge-label ${colors[i]}">${labels[i]}</span></h5>
            <div class="price">${finalPrice.toFixed(0)} ${selectedCurrency}</div>
            <div class="text-muted">per 1 channel/${selectedDuration} month${selectedDuration > 1 ? 's' : ''}</div>
            <ul class="features mt-4">
              ${features[0].map((f, j) => `<li><span>${f}</span><span>${features[1][i][j]}</span></li>`).join('')}
            </ul>
            <button class="free-btn">Try 3 days free</button>
          </div>
        </div>
      `;
    });
  }

  document.querySelectorAll('.platform-tabs .btn').forEach(btn => {
  btn.addEventListener('click', () => {
    document.querySelectorAll('.platform-tabs .btn').forEach(b => b.classList.remove('active'));
    btn.classList.add('active');
    selectedPlatform = btn.dataset.platform;
    updateCards();
  });
});


  document.querySelectorAll('.currency-btns .btn').forEach(btn => {
    btn.addEventListener('click', () => {
      document.querySelectorAll('.currency-btns .btn').forEach(b => b.classList.remove('btn-active'));
      btn.classList.add('btn-active');
      selectedCurrency = btn.dataset.currency;
      updateCards();
    });
  });

  document.querySelectorAll('.toggle-btns .btn').forEach(btn => {
    btn.addEventListener('click', () => {
      document.querySelectorAll('.toggle-btns .btn').forEach(b => b.classList.remove('btn-active'));
      btn.classList.add('btn-active');
      selectedDuration = parseInt(btn.dataset.duration);
      updateCards();
    });
  });

  updateCards();
</script>
@endsection
