@extends('front-end/master-layout')
@section('title', 'Home | contact')

@section('content')
<div class="container d-flex justify-content-center align-items-center" style="height: 80vh;">
	<div class="login w-40 p-4" style="background-color: #f8f9fa; border-radius: 8px; box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);">
		<div class="page-header text-center mb-4">
			<h1 style="font-family: 'Helvetica', sans-serif; font-weight: bold; color: #333;">User Login</h1>
		</div>

		<form id="user-login" action="{{ route('login') }}" method="post" class="form-validate form-horizontal well">
			@csrf
			<fieldset>
				<div class="mb-3">
					<label for="email">Email Address *</label>
					<input type="email" class="form-control custom-input @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email') }}" required>
					@error('email')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>

				<div class="mb-3">
					<label for="password">Password *</label>
					<input type="password" class="form-control custom-input @error('password') is-invalid @enderror" id="password" name="password" required>
					@error('password')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>

				<div class="d-flex justify-content-between align-items-center mt-2">
					<button type="submit" class="btn btn-danger custom-button">Log In</button>
					<a href="{{url('register')}}" class="mb-0">Sign up instead</a>
				</div>
			</fieldset>
		</form>
	</div>
</div>

<style>
	/* Inline CSS styling to ensure it reflects */
	.container .login {
		background-color: #f8f9fa;
		border-radius: 8px;
		padding-top: 20px;
		width: 40%;
		box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
	}

	.page-header h1 {
		font-family: 'Helvetica', sans-serif;
		font-weight: bold;
		color: #333;
	}

	.custom-input {
		border: none;
		border-bottom: 2px solid #ddd;
		border-radius: 0;
		padding: 10px; /* Adjusted padding */
		background-color: #fff;
		transition: all 0.3s ease;
	}

	.custom-input:focus {
		outline: none;
		border-bottom: 2px solid #007bff;
		box-shadow: 0px 4px 8px rgba(0, 123, 255, 0.1);
	}

	.custom-button {
		background-color: #6804e2;
		border: none;
		font-weight: bold;
		color: #fff;
		padding: 8px 16px; /* Adjusted padding */
		margin: 0; /* Ensure no margin */
	}

	.custom-button:hover {
		background-color: darkred;
		color: #fff;
	}

	.invalid-feedback {
		display: block;
		color: #6804e2;
		font-size: 12px;
		margin-top: 5px;
	}

	.is-invalid {
		border-color: #6804e2;
	}
</style>
@endsection
