<?php

// Include CRest Library
require_once(__DIR__.'/crest.php');

// Install Bitrix24 Application
$result = CRest::installApp();

// Check if the Installation is Only for REST (not Webhook)
if ($result['rest_only'] === false):
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bitrix24 Application Installation</title>

    <!-- Include Bitrix24 API Script -->
    <script src="//api.bitrix24.com/api/v1/"></script>

    <?php if ($result['install'] == true): ?>
        <!-- Initialize Bitrix24 and Finish Installation -->
        <script>
            BX24.init(function(){
                BX24.installFinish();
            });
        </script>
    <?php endif; ?>
</head>

<body>
    <?php if ($result['install'] == true): ?>
        <!-- Display Installation Success Message -->
        <p>Installation has been finished.</p>
    <?php else: ?>
        <!-- Display Installation Error Message -->
        <p>Installation error.</p>
    <?php endif; ?>
</body>

</html>

<?php endif; ?>
