<?php
// Include the CRest class
require_once __DIR__ . "/crest.php";

// Configuration variables (replace with your own)
$client_id = 'app.670d0a95d105a3.27844569';
$client_secret = 'i61EevdbbUeZCGoq08z5LrB4H8IlFjZZHR9eQwGW1LjDQg8J2A';
$domain = $_REQUEST['DOMAIN'] ?? $_SERVER['SERVER_NAME'];
$refresh_token = $_REQUEST['REFRESH_ID'] ?? '';
//$domain= "https//hamid.com";
function refresh_token($domain, $client_id, $client_secret, $refresh_token) {
    $url = "https://{$domain}/oauth/token/";
    $data = array(
        'grant_type' => 'refresh_token',
        'client_id' => $client_id,
        'client_secret' => $client_secret,
        'refresh_token' => $refresh_token
    );

    $options = array(
        'http' => array(
            'method' => 'POST',
            'header' => 'Content-Type: application/x-www-form-urlencoded',
            'content' => http_build_query($data)
        )
    );

    $context = stream_context_create($options);
    $response = file_get_contents($url, false, $context);

    if ($response === FALSE) {
        return false; // Error handling
    }

    $response_data = json_decode($response, true);
    return $response_data['access_token'];
}

// Function to add a handler in Bitrix24
function add_handler($domain, $access_token, $handler_url, $placement, $title) {
    $url = "https://{$domain}/rest/placement.bind";
    $data = array(
        'PLACEMENT' => $placement,
        'HANDLER' => $handler_url,
        'TITLE' => $title
    );

    $response = make_api_request($url, 'POST', $data, $access_token);
    return $response;
}




// Function to make API requests
function make_api_request($url, $method = 'GET', $data = array(), $access_token = null) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $access_token
    ));
    if (!empty($data)) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    }

    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}
// Function to add a custom user field
function add_user_field($url,$domain, $access_token, $field_data) {
    $response = make_api_request($url, 'POST', $field_data, $access_token);
    return $response;
}

$access_token = refresh_token($domain, $client_id, $client_secret, $refresh_token);

if ($access_token) {
    $field_data = array(
        'fields' => array(
            'FIELD_NAME' => 'payment_link',
            'EDIT_FORM_LABEL' => 'Payment Link',
            'LIST_COLUMN_LABEL' => 'My Custom Field',
            'USER_TYPE_ID' => 'string',
            'XML_ID' => 'MY_CUSTOM_FIELD',
        )
    );
    $url = "https://{$domain}/rest/crm.lead.userfield.add";
    $url1 = "https://{$domain}/rest/crm.deal.userfield.add";

    $response = add_user_field($url1,$domain, $access_token, $field_data);
    $response1 = add_user_field($url,$domain, $access_token, $field_data);
   
} else {
    echo "Failed to refresh access token.";
}
// Refresh the access token if needed
$access_token = refresh_token($domain, $client_id, $client_secret, $refresh_token);

// Example usage to add a handler
if ($access_token) {
    $handler_url = "https://integrations.notamedia.co.in/razorpay/razorpay.php";
    $placement = "CRM_DEAL_DETAIL_TAB"; // Placement where you want to add the handler
    $title = "PayBridge24 Integration";
    $response = add_handler($domain, $access_token, $handler_url, $placement, $title);
    //echo $response; // Output the response from the API call
} else {
   // echo "Failed to refresh access token.";
}


?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PayBridge24 Integration</title>
    <link rel="stylesheet" href="style2.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" crossorigin="anonymous" />
    <style>
        a:hover { text-decoration: none; color: #333; }
        a { text-decoration: none; color: #333; }
        .wrapper { display: flex; justify-content: space-between; align-items: center; }
        .btn-div { margin-right: 0; }
        .link-desc { margin-left: auto; }
        .hidden { display: none; }
    </style>
</head>

<body>

<div class="container">
    <div class="row py-3">
        <div class="col-2">
            <div class="side-bar">
                <div class="top">
                    <div class="razorpay-logo text-center">
                        <img class="logo" src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS1okjZ3XriL4GFFxQt0eihf69tNVNjquMVNQ&s?from=mdr">
                        <span class="logo-txt">Multipale</span>
                    </div>
                    <div class="logo-content">
                        <div><a href="#" class="auth">Authorization</a></div>
                        <div><a href="#" class="payment-methods">Payment methods</a></div>
                    </div>
                </div>
                <div class="side-bar-bot">
                    <a href="#" class="manual"><i class="fas fa-question"></i> Manual</a><br>
                    <a href="#" class="feedback"><i class="fas fa-comments"></i> Feedback</a>
                </div>
            </div>
        </div>
        <div class="col-10">
            <div class="form-content">
            <div class="razorpay-link">
            <div class="raz-desc">
    Payment gateways allow businesses to accept online payments securely and efficiently.<br>
    Choose a gateway to view specific details and integration options.
</div>
<div class="wrapper">
    <div class="link-desc">Select a payment gateway to see its integration options.</div>
    <div class="btn-div">
        <a href="#" class="btn btn-success" id="api-key-btn" style="display: none;">
            <i class="fa-solid fa-link"></i> Get your API keys
        </a>
    </div>
</div>
                </div>
            </div>
            <div class="row pt-5">
                <div class="col-2"></div>
                <div class="col-8">
                    <div class="form">
                        <form method="post" id="userDataForm">
                            <input type="hidden" name="url" value="<?= $domain ?>">

                            <div class="row">
                                <div class="form-group col-md-6">
 <label for="type">Type</label>
<select class="form-control" id="type" name="type">
    <option value="default">Select a Type</option>
    <option value="razorpay">Razorpay</option>
    <option value="paypal">PayPal</option>
    <option value="stripe">Stripe</option>
</select>
</div>
                                <div class="form-group col-md-6">
    <label for="country">Country</label>
    <select class="form-control" id="country" name="country">
        <option value="default">Select a Country</option>
        <option value="China">China</option>
        <option value="India">India</option>
        <option value="United States">United States</option>
        <option value="Indonesia">Indonesia</option>
        <option value="Brazil">Brazil</option>
        <option value="Nigeria">Nigeria</option>
        <option value="Bangladesh">Bangladesh</option>
        <option value="Russia">Russia</option>
        <option value="Mexico">Mexico</option>
        <option value="Japan">Japan</option>
        <option value="Ethiopia">Ethiopia</option>
        <option value="Philippines">Philippines</option>
        <option value="Egypt">Egypt</option>
        <option value="Vietnam">Vietnam</option>
        <option value="DR Congo">DR Congo</option>
        <option value="Turkey">Turkey</option>
        <option value="Iran">Iran</option>
        <option value="Germany">Germany</option>
        <option value="Thailand">Thailand</option>
    </select>
</div>

<div class="form-group col-md-6">
    <label for="currency">Currency</label>
    <select class="form-control" id="currency" name="currency">
        <option value="default"> First Select a Country</option>
    </select>
</div>
                                <div class="form-group col-md-6">
                                    <label for="secretKey">Secret Key</label>
                                    <input type="text" class="form-control" id="secretKey" name="razorpay_secret_key">
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="apiKey">API Key</label>
                                    <input type="text" class="form-control" id="apiKey" name="razorpay_api_key">
                                </div>
                                <div class="form-group col-md-6 " id="token_hide">
                                    <label for="token">Token</label>
                                    <input type="text" class="form-control" id="token" name="token">
                                </div>
                               
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary w-100" id="submitButton">Submit</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script>
$(document).ready(function() {
    const countryCurrency = {
        'China': 'CNY',
    'India': 'INR',
    'United States': 'USD',
    'Indonesia': 'IDR',
    'Brazil': 'BRL',
    'Nigeria': 'NGN',
    'Bangladesh': 'BDT',
    'Russia': 'RUB',
    'Mexico': 'MXN',
    'Japan': 'JPY',
    'Ethiopia': 'ETB',
    'Philippines': 'PHP',
    'Egypt': 'EGP',
    'Vietnam': 'VND',
    'DR Congo': 'CDF',
    'Turkey': 'TRY',
    'Iran': 'IRR',
    'Germany': 'EUR',
    'Thailand': 'THB'
    };

    // Update currency based on selected country
    $('#country').on('change', function() {
        const selectedCountry = $(this).val();
        const currencySelect = $('#currency');

        // Clear previous options in the currency dropdown
        currencySelect.empty();

        if (selectedCountry === 'default') {
            currencySelect.append('<option value="default">Select a Currency</option>');
        } else if (countryCurrency[selectedCountry]) {
            currencySelect.append(`<option value="${countryCurrency[selectedCountry]}">${countryCurrency[selectedCountry]}</option>`);
        }
    });
    $('#type').on('change',function(){
        let type = $(this).val();
          if(type=="razorpay"){
            $('#token_hide').hide();
          }else{
            $('#token_hide').show();

          }
    })
    var domain = '<?=$domain?>';

    $('#userDataForm').submit(function(e) {
        e.preventDefault();
        $.post('https://integrations.notamedia.co.in/razorpay/submit_data.php', $(this).serialize(), function(response) {
            if (response.success) {
                console.log('Form submitted successfully');
            } else {
                console.log(response.error || 'Submission failed');
            }
        });
    });
        $("#type").on("change", function () {
        const selectedType = $(this).val();
        const $description = $(".raz-desc");
        const $linkDesc = $(".link-desc");
        const $apiKeyBtn = $("#api-key-btn");

        if (selectedType === "razorpay") {
            $description.html(`Razorpay is a leading payment gateway in India, offering seamless and secure online payment solutions for businesses of all sizes.<br>
                               Trusted by millions of merchants, Razorpay enables easy integration, diverse payment options,<br>
                               and advanced features to streamline transactions and drive business growth.`);
            $linkDesc.html("Get your API keys for Razorpay integration.");
            $apiKeyBtn.html(`<i class="fa-solid fa-link"></i> Get your secret & API key`);
            $apiKeyBtn.attr("href", "#"); // Replace with Razorpay API link
            $apiKeyBtn.show(); // Show button
        } else if (selectedType === "paypal") {
            $description.html(`PayPal is a globally recognized payment gateway, offering secure and efficient online payment solutions for businesses and individuals.<br>
                               Trusted worldwide, PayPal provides easy integration, multiple currency support,<br>
                               and advanced features to facilitate seamless transactions.`);
            $linkDesc.html("Get your API keys for PayPal integration.");
            $apiKeyBtn.html(`<i class="fa-solid fa-link"></i> Get your client ID & secret`);
            $apiKeyBtn.attr("href", "#"); // Replace with PayPal API link
            $apiKeyBtn.show(); // Show button
        } else if (selectedType === "stripe") {
            $description.html(`Stripe is a powerful payment gateway designed for developers and businesses of all sizes.<br>
                               Known for its robust API and wide-ranging features, Stripe simplifies payment integration,<br>
                               enabling smooth and secure transactions globally.`);
            $linkDesc.html("Get your API keys for Stripe integration.");
            $apiKeyBtn.html(`<i class="fa-solid fa-link"></i> Get your publishable & secret keys`);
            $apiKeyBtn.attr("href", "#"); // Replace with Stripe API link
            $apiKeyBtn.show(); // Show button
        } else {
            $description.html(`Payment gateways allow businesses to accept online payments securely and efficiently.<br>
                               Choose a gateway to view specific details and integration options.`);
            $linkDesc.html("Select a payment gateway to see its integration options.");
            $apiKeyBtn.hide(); // Hide button
        }
    });
});

</script>

</body>
</html>
