<?php
include("copy-btn-ui.php");

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Retrieve GET request parameters
$requestType = $_GET['type'] ?? null;
$domain = $_GET['domain'] ?? null;
$dealId = $_GET['deal_id'] ?? null;
$refreshToken = $_GET['REFRESH_ID'] ?? null;

// Define constants for client credentials
define('CLIENT_ID', 'app.670d0a95d105a3.27844569');
define('CLIENT_SECRET', 'i61EevdbbUeZCGoq08z5LrB4H8IlFjZZHR9eQwGW1LjDQg8J2A');

// Establish a database connection
function establishConnection() {
    $connection = new mysqli("localhost", "notafwjb_hamid", "L9N}7Cdo&?=S", "notafwjb_app-integration");
    if ($connection->connect_error) {
        die("Database Connection Failed: " . $connection->connect_error);
    }
    return $connection;
}

// Refresh the access token
function refreshAccessToken($domain, $clientId, $clientSecret, $refreshToken) {
    $url = "https://{$domain}/oauth/token/";
    $data = [
        'grant_type' => 'refresh_token',
        'client_id' => $clientId,
        'client_secret' => $clientSecret,
        'refresh_token' => $refreshToken,
    ];
    $options = [
        'http' => [
            'method' => 'POST',
            'header' => 'Content-Type: application/x-www-form-urlencoded',
            'content' => http_build_query($data),
        ],
    ];
    $response = file_get_contents($url, false, stream_context_create($options));
    if ($response === false) {
        die("Error refreshing access token");
    }
    $responseData = json_decode($response, true);
    return $responseData['access_token'] ?? null;
}

// Fetch user data from the database
function fetchUserData($domain) {
    $connection = establishConnection();
    $query = "SELECT * FROM gateway_details_table WHERE bitrix24_meatch_url = ?";
    $stmt = $connection->prepare($query);
    $stmt->bind_param("s", $domain);
    $stmt->execute();
    $result = $stmt->get_result();
    $userData = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
    $connection->close();
    return $userData[0] ?? null;
}

// Make an API request
function makeApiRequest($url, $accessToken, $method = 'GET', $data = null) {
    $ch = curl_init();
    $headers = ['Authorization: Bearer ' . $accessToken];
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    if ($method === 'POST') {
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array_merge($headers, ['Content-Type: application/json']));
    }
    $response = curl_exec($ch);
    if ($response === false) {
        die("cURL Error: " . curl_error($ch));
    }
    curl_close($ch);
    return $response;
}

// Update custom field 'UF_CRM_PAYMENT_LINK' for a specific deal
function updateDealCustomField($dealId, $paymentLink, $accessToken, $domain) {
    $url = "https://{$domain}/rest/crm.deal.update.json?auth={$accessToken}";
    $data = [
        'ID' => $dealId,
        'FIELDS' => ['UF_CRM_PAYMENT_LINK' => $paymentLink],
    ];
    return makeApiRequest($url, $accessToken, 'POST', $data);
}

// Fetch deal or contact data from Bitrix24
function fetchBitrix24Data($endpoint, $accessToken, $domain) {
    $url = "https://{$domain}/rest/{$endpoint}&auth={$accessToken}";
    return makeApiRequest($url, $accessToken);
}

// Create Razorpay payment link
function createRazorpayPaymentLink($dealId, $customerName, $email, $Phone, $dealAmount, $currency, $apiKey, $apiSecret) {
    $paymentUrl = "https://api.razorpay.com/v1/payment_links";
    $paymentData = [
        'description' => 'Payment for Order',
        'amount' => $dealAmount,
        'currency' => $currency,
        'accept_partial' => true,
        'reference_id' => $dealId . "RF" . time(),
        'customer' => ['name' => $customerName, 'contact' => $Phone, 'email' => $email],
        'callback_url' => "https://integrations.notamedia.co.in/razorpay/razorpay_callback.php",
        'callback_method' => "get",
    ];
    $ch = curl_init($paymentUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($paymentData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Basic ' . base64_encode($apiKey . ':' . $apiSecret),
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

// Insert gateway transaction
function insertGatewayTransaction($user_id, $deal_id, $domain_name, $customer_name, $customer_email, $customer_contact, $paymentLinkId, $status, $description, $apiKey, $apiSecret, $refrenceId) {
    $connection = establishConnection();
    $query = "INSERT INTO gateway_transactions (user_id, deal_id, domain_name, customer_name, customer_email, customer_contact, payment_link_id, payment_status, payment_description, api_key, secret_key, refrence_id) 
              VALUES ('$user_id', '$deal_id', '$domain_name', '$customer_name', '$customer_email', '$customer_contact', '$paymentLinkId', '$status', '$description', '$apiKey', '$apiSecret','$refrenceId')";
    if (!mysqli_query($connection, $query)) {
        echo "Error: " . $query . "<br>" . mysqli_error($connection);
    }
    mysqli_close($connection);
}

// Refresh the access token
$accessToken = refreshAccessToken($domain, CLIENT_ID, CLIENT_SECRET, $refreshToken);
if (!$accessToken) die("Failed to refresh access token.");

// Fetch user data
$userData = fetchUserData($domain);
if (!$userData) die("No user data found for the domain.");

// Extract API keys from user data
$apiKey = $userData['razorpay_api_key'];
$apiSecret = $userData['razorpay_secret_key'];
$userId = $userData['user_id'];

// Process deal details
if (!empty($dealId)) {
    $dealEndpoint = "crm.deal.get?id={$dealId}";
    $dealResponse = fetchBitrix24Data($dealEndpoint, $accessToken, $domain);
    $dealData = json_decode($dealResponse, true)['result'] ?? null;

    if ($dealData) {
        $dealAmount = round($dealData['OPPORTUNITY'] ?? 0) * 100;
        $contactId = $dealData['CONTACT_ID'] ?? null;

        if ($contactId) {
            $contactEndpoint = "crm.contact.get?id={$contactId}";
            $contactResponse = fetchBitrix24Data($contactEndpoint, $accessToken, $domain);
            $contactData = json_decode($contactResponse, true)['result'] ?? null;

            if ($contactData) {
                $customerName = $contactData['NAME'] ?? '';
                $email = $contactData['EMAIL'][0]['VALUE'] ?? '';
                $Phone = $contactData['PHONE'][0]['VALUE'] ?? '';
                $currency = "INR";

                if (empty($email) || empty($dealAmount)) {
                    die("Email or deal amount is missing.");
                }

                $paymentLink = createRazorpayPaymentLink($dealId, $customerName, $email, $Phone, $dealAmount, $currency, $apiKey, $apiSecret);
                if (isset($paymentLink['id'])) {
                    $paymentLinkId = $paymentLink['id'];
                    $shortUrl = $paymentLink['short_url'] ?? null;
                    $status = $paymentLink['status'] ?? null;
                    $refrenceId = $paymentLink['reference_id'] ?? null;

                    insertGatewayTransaction($userId, $dealId, $domain, $customerName, $email, $Phone, $paymentLinkId, $status,$paymentLink['description'] ?? '', $apiKey, $apiSecret, $refrenceId);

                    if ($dealId) {
                        updateDealCustomField($dealId, $shortUrl, $accessToken, $domain);
                    }

                    if ($requestType === 'mail') {
                     $redirect_url = "https://{$domain}/bitrix/components/bitrix/crm.activity.planner/slider.php?site_id=s1&context=deal-$dealId&ajax_action=ACTIVITY_EDIT&activity_id=0&TYPE_ID=4&OWNER_ID={$dealId}&OWNER_TYPE=DEAL&OWNER_PSID=0&FROM_ACTIVITY_ID=0&MESSAGE_TYPE=&SUBJECT=&BODY={$shortUrl}&__post_data_hash=0&IFRAME=Y&IFRAME_TYPE=SIDE_SLIDER";                        
                        echo '<script>window.open("'.$redirect_url.'", "_blank")</script>';                    
                    }elseif ($requestType === 'copy') {
                        echo '<script>
                            const paymentLink = "'.$shortUrl.'";
                            const bitrix24Domain = "'.$domain.'";
                        
                        document.getElementById("copyButton").addEventListener("click", () => {
                            if (navigator.clipboard && navigator.clipboard.writeText) {
                                navigator.clipboard.writeText(paymentLink)
                                    .then(() => {
                                        alert("🎉 Payment link copied successfully! 🎉\nYou can now easily share the link with others. Click to paste anywhere and complete your payment.");
                                        redirectToBitrix24();
                                    })
                                    .catch(err => {
                                        console.error("Clipboard API failed. Using fallback:", err);
                                        copyFallback(paymentLink);
                                    });
                            } else {
                                copyFallback(paymentLink);
                            }
                        });
                    
                        function copyFallback(text) {
                            const tempTextarea = document.createElement("textarea");
                            tempTextarea.value = text;
                            document.body.appendChild(tempTextarea);
                            tempTextarea.select();
                            document.execCommand("copy");
                            document.body.removeChild(tempTextarea);
                            alert("✅ Payment link copied successfully! You can now share it with others.");
                        }
                    </script>';
                    exit;
                    }
                } else {
                    die("Failed to create Razorpay payment link.");
                }
            }
        }
    }
}
?>
