<?php
// Include the CRest class
require_once __DIR__ . "/crest.php";

// Call Bitrix24 API to fetch profile information
$result = CRest::call("profile", []);

// Extract necessary information from the API response
$photo = $result['result']['PERSONAL_PHOTO'];
$name = $result['result']['NAME'];
$last = $result['result']['LAST_NAME'];

// Extract parameters from the request
$authId = $_REQUEST["AUTH_ID"];
$refreshId = $_REQUEST["REFRESH_ID"];
$domainName = $_REQUEST["DOMAIN"];

// Bitrix24 app credentials
$client_id = 'app.65d87d166e9d26.16679595';
$client_secret = 'pvK3dpTmlwqN2yTgcEcE1OOdmSUCQMerFoKxv0o2LJgUk7rRvu';

// Database connection parameters
$servername = "localhost";  // Use your actual database server hostname or IP address
$username = "shaktatd_hamid";
$password = "D)6{.t{Yoi!D";
$dbname = "shaktatd_indiamart-hub";

// Function to make Bitrix24 API calls
function bitrix24_api($url = '', $access_token = '')
{
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => '{
            "fields": 
            {
                "FIELD_NAME": "QUERY_ID",
                "EDIT_FORM_LABEL": "QUERY Id",
                "LIST_COLUMN_LABEL": "QUERY Id",
                "USER_TYPE_ID": "string"
            }
        }',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $access_token,
            'Cookie: qmb=0.'
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    return $response;
}

// Function to refresh access token
function refresh_token($domain, $client_id, $client_secret, $refresh_token)
{
    $url = "https://{$domain}/oauth/token/";
    $data = array(
        'client_id' => $client_id,
        'client_secret' => $client_secret,
        'refresh_token' => $refresh_token,
        'grant_type' => 'refresh_token'
    );

    $options = array(
        'http' => array(
            'method' => 'POST',
            'header' => 'Content-Type: application/x-www-form-urlencoded',
            'content' => http_build_query($data)
        )
    );

    $context = stream_context_create($options);
    $response = file_get_contents($url, false, $context);
    if ($response === FALSE) {
        // Handle error
        echo 'Error refreshing access token';
        return false;
    }

    $response_data = json_decode($response, true);
   
    return $response_data;
}

$conn = new mysqli($servername, $username, $password, $dbname);
         
// Check the database connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// SQL query to update access token
$sql = "SELECT * FROM indiamarts WHERE bitrix_url IS NOT NULL";
$result = $conn->query($sql);
if ($result === false) {
    die("Error executing the query: " . $conn->error);
}

$mainUrl1 = "";
while ($row = $result->fetch_assoc()) {
    $mainUrl = $row["bitrix_url"];
    $explodUrl = explode("/", $mainUrl);
    $mainUrlExpload = $explodUrl[2];

    if ($domainName == $mainUrlExpload) {
        $mainUrl1 = $row["bitrix_url"];
        $status = $row["status"];

        // Update the database with matched Bitrix24 URL
        $updateSql = "UPDATE indiamarts SET metch_bitrix24_url = '$domainName' WHERE bitrix_url = '$mainUrl'";
        $updateResult = $conn->query($updateSql);

       if ($updateResult === false) {
            die("Error updating the database: " . $conn->error);
        } else {
            // Refresh the access token
            $response_data = refresh_token($domainName, $client_id, $client_secret, $refreshId);
            $new_access_token =$response_data['access_token'];
            $new_refresh_token =$response_data['refresh_token'];
           $updateSql = "UPDATE indiamarts SET acess_token = '$new_access_token',refresh_token='$new_refresh_token' WHERE metch_bitrix24_url = '$domainName'";
            $updateResult = $conn->query($updateSql);
            if ($updateResult == true) {
                // Make API calls to add user fields to leads and deals in Bitrix24
                $endpoint = 'crm.lead.userfield.add';
                $endpoint1 = 'crm.deal.userfield.add';
                $url = "https://{$domainName}/rest/{$endpoint}?auth={$new_access_token}";
                $url1 = "https://{$domainName}/rest/{$endpoint1}?auth={$new_access_token}";

                bitrix24_api($url,$new_access_token);
                bitrix24_api($url1,$new_access_token);
                 
            }
        }
    }
}

// Close the database connection
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Notamedia App</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" crossorigin="anonymous"/>
  <style>
    /* Header / Navbar */
    header {
      height: 70px;
      width: 100%;
      padding: 0 30px;
      background: linear-gradient(90deg,rgb(111, 40, 28), #ff416c); /* Red gradient */
      position: fixed;
      z-index: 100;
      box-shadow: 1px 1px 15px rgba(161, 182, 253, 0.825);
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .logo {
      width: 50px;
      height: 30px;
    }

    .card {
      margin-top: 100px;
      border: 1px solid #e0e0e0;
      border-radius: 8px;
    }

    .card-title {
      padding: 20px;
    }

    .green {
      color: green;
    }

    .red {
      color: red;
    }

    .form-group {
      padding: 20px;
    }

    .form-control {
      width: 70%;
      padding: 10px 15px;
      border-radius: 6px;
      border: 1px solid #ced4da;
      transition: border-color 0.3s;
    }

    .form-control:focus {
      border-color: #007bff;
      box-shadow: 0 0 5px rgba(0, 123, 255, 0.4);
    }

    .footer-note {
      background: #fff;
      padding: 20px;
      border-radius: 6px;
      margin: 20px;
      color: #444;
    }

    .footer-note span {
      color: #ff5e14;
      font-weight: bold;
    }

    .custom-instructions {
      background: linear-gradient(90deg,rgb(111, 40, 28), #ff416c); /* UL background */
      padding: 20px;
      border-radius: 6px;
      margin: 20px;
    }

    .custom-instructions li {
      margin-bottom: 10px;
      color: #fff; /* White list item text */
    }

    /* Footer styles */
    .copyright-area {
      background: linear-gradient(90deg, #ff4b2b, #ff416c); /* Red gradient */
      padding: 20px 0;
      width: 100%;
    }

    .copyright-text p {
      margin: 0;
      font-size: 14px;
      color: #fff;
      text-align: center;
    }

    a {
      color: #ffe9d6;
    }
  </style>
</head>
<body>
  <header>
    <nav class="navbar navbar-light">
      <a class="navbar-brand" href="#"><img class="logo" src="image (9).png" alt="Logo"></a>
    </nav>
  </header>

  <div class="container py-3">
    <div class="row mt-1">
      <div class="col-12">
        <div class="card">
          <div class="content">
            <div class="card-title">
              <?php if (!empty($mainUrl1)) { ?>
                <h6 class="green">Connected Notamedia to Bitrix24</h6>
                <?php if ($status != 1) { ?>
                  <p class="red">Plan not chosen — please select a plan from your dashboard.</p>
                <?php } ?>
              <?php } else { ?>
                <h6 class="red">First setup Notamedia Application Portal and enter your inbound webhook URL in the CRM integration menu of Notamedia. Without this, you cannot use this application.</h6>
              <?php } ?>
            </div>

            <div class="form-group">
              <label for="exampleInputEmail1">Webhook URL</label>
              <input type="url" class="form-control" id="exampleInputEmail1" name="url" value="<?= $mainUrl1 ?>" readonly>
              <div class="footer-note mt-2">
                <b>NOTE:</b> If your application is not connected to the Portal, you will see a blank URL with "Not Connected" status above.
              </div>
            </div>

            <div class="custom-instructions">
              <ul>
                <li>Install Bitrix24 Marketplace</li>
                <li>Go to Notamedia Application Portal through this link:</li>
                <li><span>https://shaktiinfotech.in/indiamart-hub/</span></li>
                <li>Login or register on Notamedia</li>
                <li>Setup your custom deal leads field on Notamedia</li>
              </ul>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Footer -->
  <div class="copyright-area">
    <div class="copyright-text">
      <p>&copy; 2024, All Rights Reserved <a href="#">Notamedia Indiamart</a></p>
    </div>
  </div>

  <!-- JS Scripts -->
  <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js" crossorigin="anonymous"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
</body>
</html>
