<?php
session_set_cookie_params([
  'lifetime' => 0,
  'path' => '/',
  'domain' => '.' . $_SERVER['HTTP_HOST'],  // Dynamic domain fetch karna
  'secure' => true,
  'httponly' => true,
  'samesite' => 'None'
]);
session_start();
    include './header.php';
   
    require_once './src/user.php';
    require_once './src/Database.php';
    
  

// Check and assign session data with null fallback
$responsibleId = isset($_SESSION['responsible_id']) && !empty($_SESSION['responsible_id']) ? $_SESSION['responsible_id'] : null;
$projectId     = isset($_SESSION['project_id']) && !empty($_SESSION['project_id']) ? $_SESSION['project_id'] : null;
$folderId      = isset($_SESSION['folder_id']) && !empty($_SESSION['folder_id']) ? $_SESSION['folder_id'] : null;
$bitrix24UserId      = isset($_SESSION['bitrix_user_id']) && !empty($_SESSION['bitrix_user_id']) ? $_SESSION['bitrix_user_id'] : null;

$query = http_build_query([
  'bitrix_user'    => $bitrix24UserId,
  'responsible_id' => $responsibleId,
  'folder_id'      => $folderId,
  'project_id'     => $projectId,
]);

$users = User::find_acording_bitrx($bitrix24UserId);
?>

<div id="content-wrapper">

    <div class="container-fluid">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="#">Users</a>
            </li>
            <li class="breadcrumb-item active">Overview</li>
        </ol>
        <a class="btn btn-primary my-3" href="newuser.php?<?= htmlspecialchars($query) ?>">
            <i class="fa fa-plus"></i> Create New User
        </a>

        <div class="card mb-3">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-sm" id="dataTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Created at</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($users)): ?>
                                <tr>
                                    <td colspan="5" class="text-center">Not Found</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($users as $user): ?>
                                    <?php if ($user && is_object($user)): ?>  <!-- Check if $user is not null and is an object -->
                                        <tr>
                                            <td><?php echo $user->name ?: 'Not Found'; ?></td>
                                            <td><?php echo $user->email ?: 'Not Found'; ?></td>
                                            <td><?php echo $user->phone ?: 'Not Found'; ?></td>
                                            <td><?php echo $user->created_at ?: 'Not Found'; ?></td>
                                            <td>
                                                <a href="edit-users-password.php?user_id=<?php echo $user->id; ?>" class="btn btn-primary">Update Password</a>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>
  <!-- /.container-fluid -->

  <!-- Sticky Footer -->
  <footer class="sticky-footer">
    <div class="container my-auto">
      <div class="copyright text-center my-auto">
      <span>Copyright © Synchlab Coding</span>
      </div>
    </div>
  </footer>

</div>
<!-- /.content-wrapper -->

</div>
<!-- /#wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
  <i class="fas fa-angle-up"></i>
</a>

<!-- Logout Modal-->
<div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
  aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">×</span>
        </button>
      </div>
      <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
        <a class="btn btn-primary" href="./index.php">Logout</a>
      </div>
    </div>
  </div>
</div>

<!-- Bootstrap core JavaScript-->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

<!-- Core plugin JavaScript-->
<script src="vendor/jquery-easing/jquery.easing.min.js"></script>

<!-- Page level plugin JavaScript-->
<script src="vendor/chart.js/Chart.min.js"></script>
<script src="vendor/datatables/jquery.dataTables.js"></script>
<script src="vendor/datatables/dataTables.bootstrap4.js"></script>

<!-- Custom scripts for all pages-->
<script src="js/sb-admin.min.js"></script>

<!-- Demo scripts for this page-->
<script src="js/demo/datatables-demo.js"></script>
<script src="js/demo/chart-area-demo.js"></script>

</body>

</html>