<?php

session_start();

// Redirect if not logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: http://localhost/help/helpdesk-core-php/ticket-user/login-reg.php");
    exit;
}

$folderId=$_SESSION['folder_id'];
$projectId= $_SESSION['project_id'];
 $BitrixUser =$_SESSION['bitrix_user_id'];
$username = isset($_SESSION['username']) 
    ? "Welcome, " . htmlspecialchars($_SESSION['username']) 
    : "Welcome, Guest!";     
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Help Desk</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">

    <style>
          body {
			font-family: Arial, sans-serif;
			margin: 20px;
			
		}
        .navbar { background-color: #333; color: #fff; }
        .navbar-brand { color: #fff; }
        .container { max-width: 900px; }
        .card { max-width: 500px; margin: auto; padding: 20px; }
        .table-container { margin-top: 20px; display: none; }
      
		.block {
			background: #fff;
			padding: 20px;
			border-radius: 10px;
			max-width: 500px;
			margin: auto;
             border: 1px solid black;
              margin-top: 20px;
		}
		.title h2 {
			margin: 0 0 20px;
		}
		.writing {
			display: flex;
			gap: 10px;
			margin-bottom: 20px;
		}
		.textarea {
			flex: 1;
			min-height: 60px;
			border: 1px solid #ccc;
			border-radius: 8px;
			padding: 10px;
		}
		.send-btn {
			padding: 10px 20px;
			border: none;
			background-color: #007bff;
			color: white;
			border-radius: 8px;
			cursor: pointer;
		}
		.send-btn:hover {
			background-color: #0056b3;
		}
		.comment {
			border-top: 1px solid #eee;
			padding-top: 15px;
			margin-top: 15px;
		}
		.user-banner {
			display: flex;
			align-items: center;
			gap: 10px;
		}
		.avatar img {
			width: 40px;
			height: 40px;
			border-radius: 50%;
			object-fit: cover;
		}
		.content p {
			margin: 10px 0;
		}
		.reply {
			margin-left: 40px;
		}
		span.is-mute {
			color: #888;
			font-size: 12px;
			margin-top: 5px;
			display: inline-block;
		}
        .content {
	position: relative;
	padding-bottom: 5px;
}

.meta-row {
	display: flex;
	justify-content: space-between;
	align-items: center;
	font-size: 12px;
	color: #888;
	margin-top: 5px;
}
.date-time {
	position: absolute;
	right: 10px;
	bottom: 5px;
	font-size: 12px;
	color: #888;
}
.content {
	position: relative;
	padding-bottom: 20px;
}
 /* Styling for file upload input */
 .file-upload {
        width: 100%;  /* Set width to 100% (can change based on needs) */
        max-width: 300px; /* Set a maximum width if needed */
        height: 40px; /* Set height */
        margin: 10px 0; /* Set margin to add space around the file input */
        padding: 5px; /* Optional: Add padding for better appearance */
        font-size: 14px; /* Optional: Adjust font size */
        border: 1px solid #ccc; /* Optional: Add border */
        border-radius: 5px; /* Optional: Round the corners */
    }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-light bg-light">
    <a class="navbar-brand" href="#">Help Desk</a>

    <ul class="navbar-nav ml-auto">
        <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
               data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
               <i class="fa fa-user-circle"></i> <?php echo htmlspecialchars($username); ?>
            </a>
            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="userDropdown">
            <span class="dropdown-item-text"><strong><?php echo htmlspecialchars($username); ?></strong></span>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item" href="update-password.php">Update Password</a>
                <a class="dropdown-item" href="logout.php">Logout</a>
            </div>
        </li>
    </ul>
</nav>

