<?php
session_start();
require_once '../src/Database.php';
$conn = Database::getInstance();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email    = trim($_POST['email']);
    $password = trim($_POST['password']);

    // Corrected query (added comma between columns)
    $stmt = $conn->prepare("SELECT id, name, folder_id, project_id, bitrix24_user_id, password FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 1) {
        // Bind all columns
        $stmt->bind_result($id, $name, $folderId, $projectId, $bitrix24UserId, $hashedPassword);
        $stmt->fetch();

        if (password_verify($password, $hashedPassword)) {
            // Set session variables
            $_SESSION['user_id']        = $id;
            $_SESSION['username']       = $name;
            $_SESSION['folder_id']      = $folderId;
            $_SESSION['project_id']     = $projectId;
            $_SESSION['bitrix_user_id'] = $bitrix24UserId;

            // Redirect to user dashboard
            header("Location: http://localhost/help/helpdesk-core-php/ticket-user");
            exit;
        } else {
            echo "❌ Incorrect password.";
        }
    } else {
        echo "❌ User not found.";
    }

    $stmt->close();
    $conn->close();
}
?>
