<?php
require_once '../src/AccessToken.php';
require_once '../src/Database.php';
$conn = Database::getInstance();

$user_id = $_GET['user_id'];
 function getBitrixUserIdById($id) {
   global  $conn;
    $id = intval($id); 

    $sql = "SELECT bitrix24_user_id FROM users WHERE id = $id";
    $res = $conn->query($sql);

    if ($res && $res->num_rows > 0) {
        $row = $res->fetch_assoc();
        return $row['bitrix24_user_id'];
    }

    return null; // not found
}
$bitrix24_user= getBitrixUserIdById($user_id);
 // Get access token and client endpoint
 $tokenData = AccessToken::getAccessTokenByUserId($bitrix24_user);
 $accessToken = $tokenData['access_token'];
 $clientEndPoint = $tokenData['client_endpoint'];
 $responsibleId = $tokenData['repo_id'];
 

 
// JOIN tickets with users to get name, email, phone
function updateTicketStatus($conn, $taskId, $ticketUserId, $newStatus) {
    $sql = "UPDATE tickets SET status = ? WHERE task_id = ? AND ticket_user_id = ?";
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        return "Prepare failed: " . $conn->error;
    }

    $stmt->bind_param("iii", $newStatus, $taskId, $ticketUserId);

    if ($stmt->execute()) {
       
    } else {
       // return "Error updating ticket status: " . $stmt->error;
    }

    $stmt->close();
}

$sql = "
    SELECT 
        tickets.*, 
        users.name AS user_name, 
        users.email AS user_email, 
        users.phone AS user_phone
    FROM tickets
    JOIN users ON tickets.ticket_user_id = users.id
    WHERE tickets.ticket_user_id = ?
    ORDER BY tickets.created_at DESC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$tickets = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
         
        $row['task_id'] = !empty($row['task_id']) ? $row['task_id'] : '';

        // Fetch Bitrix24 Task Status if Task ID exists
        if (!empty($row['task_id'])) {
            $bitrix_api_url = $clientEndPoint."tasks.task.get.json?auth=".$accessToken."&id=".$row['task_id'];
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL,$bitrix_api_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $bitrix_response = curl_exec($ch);
            curl_close($ch);

            $task_data = json_decode($bitrix_response, true);
    
            if (isset($task_data['result']['task']['status'])) {
                $row['bitrix_status'] = $task_data['result']['task']['status'];
                $status = $task_data['result']['task']['status'];
                updateTicketStatus($conn,$row['task_id'] , $user_id,$status);
            } else {
                $row['bitrix_status'] = 'Unknown';
            }
        } else {
            $row['bitrix_status'] = 'Pending';
        }

        $tickets[] = $row;
    }
}
$conn->close();
header('Content-Type: application/json');
echo json_encode($tickets);
?>
