<?php
require_once '../src/AccessToken.php';
require_once '../src/Database.php';
$conn = Database::getInstance();  // Keep the connection open

if (!isset($_GET['user_id'])) {
    echo "User ID not provided.";
    exit();
}
$bitrix24UserId = $_GET['user_id'];
$tokenData = AccessToken::getAccessTokenByUserId($bitrix24UserId);
$accessToken = $tokenData['access_token'];
$clientEndPoint = $tokenData['client_endpoint'];
$responsibleId = $tokenData['repo_id'];

function call_api($clientEndPoint,$accessToken,$method, $params = []) {
    $base_url = $clientEndPoint.$method."?auth=".$accessToken;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $base_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

$sql = "SELECT bitrix_user_id, email, issue_type, task_id FROM tickets WHERE sorce='email'AND bitrix_user_id =".$bitrix24UserId;
$result = mysqli_query($conn, $sql);

$processedActivities = [];

if (mysqli_num_rows($result) > 0) {
    while ($ticket = mysqli_fetch_assoc($result)) {
        $subject_clean = trim($ticket['issue_type']);
 //echo $subject_clean ."<br>";
        $params = [
            "filter" => [
                "TYPE_ID" => 4,
                "DIRECTION" => 1,
                "SUBJECT" => "Re: ".$subject_clean,
                "COMPLETED" => "N"
            ],
            "select" => [
                "ID", "SUBJECT", "DESCRIPTION", "CREATED", "OWNER_ID", "OWNER_TYPE_ID",
                "RESPONSIBLE_ID", "AUTHOR_ID", "COMMUNICATIONS", "FILES"
            ],
            "order" => ["ID" => "desc"],
          
        ];

        
        $method='/crm.activity.list.json';
        $response=call_api($clientEndPoint,$accessToken,$method, $params);
         
        if (!empty($response['result'])) {
            foreach ($response['result'] as $activity) {
                $cleanBody = clean_html($activity['DESCRIPTION'] ?? '');
                $emailId = $activity["ID"];

                $processedActivities[] = [
                    'task_id' => $ticket['task_id'],
                    'email' => $ticket['email'],
                    'description' => $cleanBody,
                    'email_id' => $emailId
                ];

                if (!empty($activity["FILES"])) {
                    foreach ($activity["FILES"] as $fileId) {
                        $query_params = [
                            "taskId" => $ticket['task_id'],
                            "fileId" => $fileId['id']
                        ];
                        
                        $method='/tasks.task.files.attach';
                  $response=call_api($clientEndPoint,$accessToken,$method, $query_params = []);
                    }
                }
            }
        }
    }
}

function clean_html($html) {
    $html = preg_replace('#<style.*?>.*?</style>#si', '', $html);
    $html = preg_replace('#<script.*?>.*?</script>#si', '', $html);
    $html = preg_replace('#<!--.*?-->#s', '', $html);
    $html = preg_replace('#<blockquote.*?>.*?</blockquote>#si', '', $html);
    $html = strip_tags($html);
    $html = html_entity_decode($html, ENT_QUOTES, 'UTF-8');
    $html = preg_replace('/On\s.+?wrote:/is', '', $html);
    $html = preg_replace('/(From:|To:|Subject:|Date:).*/i', '', $html);
    $html = preg_replace('/-----Original Message-----/i', '', $html);
    $html = preg_replace('/-{2,}\s*Forwarded message\s*-{2,}/i', '', $html);
    $html = preg_replace('/\n>+.*/', '', $html);
    $html = preg_replace('/\s+/', ' ', $html);
    return trim($html);
}

if ($processedActivities) {
    foreach ($processedActivities as $item) {
        $params= [
            "taskId" => $item['task_id'],
            "fields" => [
                "POST_MESSAGE" => $item['description']
            ]
            ];
        $method='/task.commentitem.add';
        $response=call_api($clientEndPoint,$accessToken,$method, $params);
        
        if (!empty($response['result'])) {
            $update_params = [
                "ID" => $item['email_id'],
                "FIELDS" => [
                    "COMPLETED" => "Y"
                ]
            ];   
            $method='/crm.activity.update.json';
            $response=call_api($clientEndPoint,$accessToken,$method, $update_params);
           
        }
    }
} else {
    echo "No incoming email activity found.";
}
?>
