<?php
include("user_header.php");
$taskId = $_GET['task_id'];
$bitrix24User = $_GET['btrix24_user'];
?>
<div class="block">
	<div class="title">
		<h2>Comments</h2>
	</div>

	<!-- Writing Area -->
    <form id="commentForm">
        <div class="writing">
            <div contenteditable="true" class="textarea" id="comment" spellcheck="false"></div>
        </div>

        <!-- File Upload Input -->
        <div>
            <input type="file" id="file-upload" class="file-upload" name="file-upload">
        </div>

        <button type="submit" class="send-btn" id="send-btn">Send</button>
    </form>

	<!-- Example Comment -->
	<div class="comment">
		<div class="user-banner">
			<div class="avatar">
				<img src="https://img.freepik.com/premium-vector/comments-icon_159242-10532.jpg?w=86" alt="">
			</div>
			<h5>This is Your Task Comment</h5>
		</div>
        <div id="yourCommentContainer"></div>
	</div>
</div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script>
function timeSince(date) {
    const seconds = Math.floor((new Date() - date) / 1000);
    let interval = Math.floor(seconds / 3600);
    if (interval >= 1) return interval + " hours ago";
    interval = Math.floor(seconds / 60);
    if (interval >= 1) return interval + " minutes ago";
    return Math.floor(seconds) + " seconds ago";
}

$(document).ready(function() {
    let taskId = "<?= $taskId ?>";
    let bitrix24Id = "<?= $bitrix24User ?>";

    // Submit comment
    $("#commentForm").on("submit", function(e) {
        e.preventDefault();

        let commentValue = $("#comment").text().trim();
        if (commentValue === "") {
            alert("Please enter a comment.");
            return;
        }

        $.ajax({
            url: 'comment_get_api.php',
            type: 'POST',
            data: {
                taskId: taskId,
                commentValue: commentValue,
                bitrix24Id: bitrix24Id    
            },
            success: function(response) {
                $("#comment").empty();
                loadComments();
            },
            error: function(xhr, status, error) {
                console.error('POST Error:', error);
            }
        });
    });

    // Load comments
    function loadComments() {
        $.ajax({
            url: 'comment_get_api.php',
            type: 'GET',
            data: {
                taskId: taskId,
                bitrix24Id: bitrix24Id    
            },
            dataType: 'json',
            success: function(response) {
                $('#yourCommentContainer').empty();
                if (response.result && Array.isArray(response.result)) {
                    response.result.forEach(function(comment) {
                        const postMessage = comment.POST_MESSAGE || '';
                        const postDate = comment.POST_DATE || '';
                        const timeAgo = timeSince(new Date(postDate));

                        const contentBlock = `
                            <div class="content">
                                <p class="post_msg">${postMessage}</p>
                                <div class="meta-row">
                                    <span class="is-mute">${timeAgo}</span>
                                    <span class="date-time">${postDate}</span>
                                </div>
                            </div>
                        `;
                        $('#yourCommentContainer').append(contentBlock);
                    });
                } else {
                    console.error("Invalid response format:", response);
                }
            },
            error: function(xhr, status, error) {
                console.error('GET Error:', error);
            }
        });
    }

    loadComments(); // initial load
});
</script>
</body>
</html>
