
<?php
include("user_header.php");
?>
    <div class="container">
        <h1 class="text-center mt-4">Create Ticket</h1>
        <div class="card p-3">
    <form id="ticket-form"enctype="multipart/form-data">
        <input type="hidden" id="bitrix" name=" bitrix_user" value="<?=$BitrixUser?>">
        <input type="hidden" id="project" name="project_id" value="<?=$projectId?>">
        <input type="hidden" id="folder" name="folder_id" value="<?=$folderId?>">
        <div class="form-row">
            <div class="form-group col-md-12">
                <label for="issue-type">Issue Type:</label>
                <select class="form-control" id="issue-type" required>
                    <option value="">Select Issue Type</option>
                    <option value="Technical">Technical</option>
                    <option value="Non-Technical">Non-Technical</option>
                </select>
            </div>

            <div class="form-group col-md-12">
                <label for="priority">Priority:</label>
                <select class="form-control" id="priority" required>
                    <option value="">Select Priority</option>
                    <option value="0">Low</option>
                    <option value="1">Normal</option>
                    <option value="2">High</option>
                </select>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-12">
                <label for="description">Description:</label>
                <textarea class="form-control" id="description" rows="3" required></textarea>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group col-md-12">
                <label for="description">Attachment:</label>
        <input type="file"class="form-control" name="attachment" id="attachment">
            </div>
        </div>
        <button type="submit" class="btn btn-primary btn-block">Create Ticket</button>
    </form>
</div>

        <div class="table-container">
            <table class="table table-striped mt-4" id="ticket-table">
                <thead>
                    <tr>
                        <th>Ticket ID</th>
                        <th>Issue Type</th>
                        <th>Priority</th>
                        <th>Description</th>
                        <th>Date Created</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody id="ticket-tbody"></tbody>
            </table>
        </div>
    </div>

   

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
    <script>
        $(document).ready(function() {
    const userId = "<?= $_SESSION['user_id'] ?>";

    $("#ticket-form").submit(function(e) {
        e.preventDefault();

        const ticketID = generateTicketID();
        const formData = new FormData();

        formData.append("id", ticketID);
        formData.append("ticketUserId", userId);
        formData.append("issueType", $("#issue-type").val());
        formData.append("priority", $("#priority").val());
        formData.append("bitrix24_user", $("#bitrix").val());
        formData.append("project_id", $("#project").val());
        formData.append("folder_id", $("#folder").val());
        formData.append("description", $("#description").val());
        formData.append("dateCreated", new Date().toLocaleString());
        formData.append("status", "Open");

        const fileInput = $("#attachment")[0];
        if (fileInput.files.length > 0) {
            formData.append("attachment", fileInput.files[0]);
        }

        $.ajax({
            url: "process_ticket.php",
            type: "POST",
            data: formData,
            processData: false, 
            contentType: false,
            success: function(response) {
                console.log(response);
                $("#ticket-form")[0].reset();
                fetchTickets(); // New ticket ke baad refresh list
            }
        });
    });

    function fetchTickets() {
        $.ajax({
            url: "get_tickets.php",
            type: "GET",
            data: { user_id: userId },
            dataType: "json",
            success: function(response) {
                console.log(response);

                $(".table-container").show();
                $("#ticket-tbody").empty();

                response.forEach(function(ticket) {
                     console.log(ticket);
                    let bitrixStatus = "";
                    let priorityText = "Unknown";
                    $("#username").text(ticket.user_name);
                     
                      switch (parseInt(ticket.priority)) {
                        case 0: priorityText = "Low"; break;
                        case 1: priorityText = "Normal"; break;
                        case 2: priorityText = "High"; break;
                    }

                    switch (parseInt(ticket.status)) {
                    case 1: bitrixStatus = "New"; break;
                    case 2: bitrixStatus = "Pending"; break;
                    case 3: bitrixStatus = "In Progress"; break;
                    case 4: bitrixStatus = "Waiting"; break;
                    case 5: bitrixStatus = "Completed"; break;
                    case 6: bitrixStatus = "Deferred"; break;
                    case 7: bitrixStatus = "Declined"; break;
                    default: bitrixStatus = "Unknown"; break;
                }


                    const taskLink = ticket.task_id ? `<a href="comment_get.php?task_id=${ticket.task_id}&btrix24_user=${ticket.bitrix_user_id}" class="btn btn-sm btn-primary view-btn">View</a>` : 'N/A';

                    $("#ticket-tbody").append(`
                        <tr>
                            <td>${ticket.ticket_id}</td>
                            <td>${ticket.issue_type}</td>
                            <td>${priorityText}</td>
                            <td>${ticket.description}</td>
                            <td>${ticket.created_at}</td>
                            <td>${bitrixStatus}</td>
                            <td>${ticket.task_id ? ticket.task_id : 'N/A'}</td>
                            <td>${taskLink}</td>
                        </tr>
                    `);
                });
            }
        });
    }

    fetchTickets();

    function generateTicketID() {
        // Safer way
        return 'TICKET-' + Math.random().toString(36).substr(2, 9).toUpperCase();
    }
});

    </script>
</body>
</html>
