<?php
class User {
    public $id = null;

    public $name = '';
    public $email = '';
    public $phone = '';
    public $password = '';
    public $role = '';
    public $avatar = '';
    public $lastPassword = '';
    
    public $bitrix24_user_id = '';
    public $project_id = '';
    public $folder_id = '';
    public $created_at = '';

    private $db;

    public function __construct($data = null) {
        $this->name = $data['name'] ?? null;
        $this->email = $data['email'] ?? null;
        $this->phone = $data['phone'] ?? null;
        $this->password = $data['password'] ?? null;
        $this->lastPassword = $data['last_password'] ?? null;
        $this->role = $data['role'] ?? 'member';
        
        $this->bitrix24_user_id = $data['bitrix24_user_id'] ?? null;
        $this->project_id = $data['project_id'] ?? null;
        $this->folder_id = $data['folder_id'] ?? null;

        $this->db = Database::getInstance();
    }

    public function save() {
        $sql = "INSERT INTO users (name, email, phone, password, role, last_password, bitrix24_user_id, project_id, folder_id)
                VALUES (
                    '$this->name',
                    '$this->email',
                    '$this->phone',
                    '$this->password',
                    '$this->role',
                    '$this->lastPassword',
                    '$this->bitrix24_user_id',
                    '$this->project_id',
                    '$this->folder_id'
                )";
        if ($this->db->query($sql) === false) {
            throw new Exception($this->db->error);
        }

        return $this->db->insert_id;
    }

    public static function find($id){
        $sql = "SELECT * FROM users WHERE id = '$id'";
        $self = new static;
        $res = $self->db->query($sql);
        if($res->num_rows < 1) return false;
        $self->populateObject($res->fetch_object());
        return $self;
    }

    public static function find_acording_bitrx($id){
        $sql = "SELECT * FROM users WHERE bitrix24_user_id = '$id'";
        $self = new static;
        $res = $self->db->query($sql);
        if($res->num_rows < 1) return new static;

        while($row = $res->fetch_object()){
            $user = new static;
            $user->populateObject($row);
            $users[] = $user;
        }

        return $users;
    }
    public static function findAll(){
        $sql = "SELECT * FROM users ORDER BY id DESC";
        $users = [];
        $self = new static;
        $res = $self->db->query($sql);
        
        if($res->num_rows < 1) return new static;

        while($row = $res->fetch_object()){
            $user = new static;
            $user->populateObject($row);
            $users[] = $user;
        }

        return $users;
    }
    public function update() {
        $sql = "UPDATE users SET name = ?, email = ?, phone = ?, password = ? WHERE id = ?";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bind_param('sssss', $this->name, $this->email, $this->phone, $this->password, $this->id);
        
        if ($stmt->execute()) {
            return true;
        } else {
            throw new Exception("Error updating user: " . $this->db->error);
        }
    }
    
    public function populateObject($object){
        foreach($object as $key => $property){
            $this->$key = $property;
        }
    }
}
