<?php
class Ticket
{
    public $id = null;
    public $ticket_id = '';
    public $task_id = null;
    public $bitrix_user_id = null;
    public $ticket_user_id = null;
    public $project_id = null;
    public $user_email = '';
    public $user_phone = '';
    public $user_name = '';
    public $issue_type = '';
    public $description = '';
    public $created_at = null;
    public $updated_at = null;
    public $status = '';
    public $priority = '';

    private $db = null;

    public function __construct($data = null)
    {
        $this->db = Database::getInstance();
        return $this;
    }
    public static function delete($id): bool 
    {
        $self = new static;
        $stmt = $self->db->prepare("DELETE FROM tickets WHERE id = ?");
        return $stmt->execute([$id]);
    }
    
    public static function findAll($bitrix24Id): array
    {
        $sql = "SELECT 
            tickets.*, 
            users.name AS user_name, 
            users.email AS user_email,
            users.phone AS user_phone
        FROM 
            tickets
        LEFT JOIN 
            users ON tickets.ticket_user_id = users.id
        WHERE 
            tickets.bitrix_user_id = {$bitrix24Id}
           ";
        $tickets = [];
        $self = new static;
        $res = $self->db->query($sql);

        if ($res->num_rows < 1) {
            return [];
        }

        while ($row = $res->fetch_object()) {
            $ticket = new static;
            $ticket->populateObject($row);
            $tickets[] = $ticket;
        }

        return $tickets;
    }
    public static function findStatusNew($bitrix24Id): array
    {
        $sql = "SELECT 
            tickets.*, 
            users.name AS user_name, 
            users.email AS user_email,
            users.phone AS user_phone
        FROM 
            tickets
        LEFT JOIN 
            users ON tickets.ticket_user_id = users.id
        WHERE 
           tickets.status=1 AND tickets.bitrix_user_id = {$bitrix24Id}
           ";
        $tickets = [];
        $self = new static;
        $res = $self->db->query($sql);

        if ($res->num_rows < 1) {
            return [];
        }

        while ($row = $res->fetch_object()) {
            $ticket = new static;
            $ticket->populateObject($row);
            $tickets[] = $ticket;
        }

        return $tickets;
    }
    public static function findStatusProgress($bitrix24Id): array
    {
        $sql = "SELECT 
            tickets.*, 
            users.name AS user_name, 
            users.email AS user_email,
            users.phone AS user_phone
        FROM 
            tickets
        LEFT JOIN 
            users ON tickets.ticket_user_id = users.id
        WHERE 
           tickets.status=3 AND tickets.bitrix_user_id = {$bitrix24Id}";
        $tickets = [];
        $self = new static;
        $res = $self->db->query($sql);

        if ($res->num_rows < 1) {
            return [];
        }

        while ($row = $res->fetch_object()) {
            $ticket = new static;
            $ticket->populateObject($row);
            $tickets[] = $ticket;
        }

        return $tickets;
    }
    public static function findStatusPending($bitrix24Id): array
    {
        $sql = "SELECT 
            tickets.*, 
            users.name AS user_name, 
            users.email AS user_email,
            users.phone AS user_phone
        FROM 
            tickets
        LEFT JOIN 
            users ON tickets.ticket_user_id = users.id
        WHERE 
           tickets.status=2 AND tickets.bitrix_user_id = {$bitrix24Id}
           ";
        $tickets = [];
        $self = new static;
        $res = $self->db->query($sql);

        if ($res->num_rows < 1) {
            return [];
        }

        while ($row = $res->fetch_object()) {
            $ticket = new static;
            $ticket->populateObject($row);
            $tickets[] = $ticket;
        }

        return $tickets;
    }
    public static function findStatusClose($bitrix24Id): array
    {
        $sql = "SELECT 
            tickets.*, 
            users.name AS user_name, 
            users.email AS user_email,
            users.phone AS user_phone
        FROM 
            tickets
        LEFT JOIN 
            users ON tickets.ticket_user_id = users.id
        WHERE 
           tickets.status=5 AND tickets.bitrix_user_id = {$bitrix24Id}
           ";
        $tickets = [];
        $self = new static;
        $res = $self->db->query($sql);

        if ($res->num_rows < 1) {
            return [];
        }

        while ($row = $res->fetch_object()) {
            $ticket = new static;
            $ticket->populateObject($row);
            $tickets[] = $ticket;
        }

        return $tickets;
    }


    public static function findByStatus($status): array
    {
        $sql = "SELECT * FROM ticket WHERE status = '$status' ORDER BY id DESC";
        $self = new static;
        $tickets = [];
        $res = $self->db->query($sql);

        while ($row = $res->fetch_object()) {
            $tickets[] = $row;
        }

        return $tickets;
    }

    public function unassigned()
    {
        $sql = "SELECT * FROM ticket WHERE team_member = '' ORDER BY id DESC";
        $self = new static;
        $tickets = [];
        $res = $self->db->query($sql);

        while ($row = $res->fetch_object()) {
            $tickets[] = $row;
        }

        return $tickets;
    }

    public static function findByMember($member)
    {
        $sql = "SELECT * FROM ticket WHERE team_member = '$member' ORDER BY id DESC";
        $self = new static;
        $tickets = [];
        $res = $self->db->query($sql);

        while($row = $res->fetch_object()) {
            $ticket = new static;
            $ticket->populateObject($row);
            $tickets[] = $ticket;
        }

        return $tickets;
    }

    public function displayStatusBadge(): string
    {
        $badgeType = '';
        if ($this->status == 'open') {
            $badgeType = 'danger';
        } else if ($this->status == 'pending') {
            $badgeType = 'warning';
        } else if ($this->status == 'solved') {
            $badgeType = 'success';
        } else if ($this->status == 'closed') {
            $badgeType = 'info';
        }

        return '<div class="badge badge-' . $badgeType . '" role="badge"> ' . ucfirst($this->status) . '</div>';
    }

    public function populateObject($object): void
    {
        foreach ($object as $key => $property) {
            $this->$key = $property;
        }
    }
}
