<?php
session_set_cookie_params([
  'lifetime' => 0,
  'path' => '/',
  'domain' => '.' . $_SERVER['HTTP_HOST'],  // Dynamic domain fetch karna
  'secure' => true,
  'httponly' => true,
  'samesite' => 'None'
]);
session_start();
include './header.php';
require_once './src/Database.php';
$bitrix24UserId = isset($_SESSION['bitrix_user_id']) && !empty($_SESSION['bitrix_user_id']) ? $_SESSION['bitrix_user_id'] : null;


  require_once './src/ticket.php';
    
    $ticket = new Ticket();

    $allTicket = $ticket::findStatusNew($bitrix24UserId);
    

    if (isset($_GET['del'])) {

      $id = $_GET['del'];
      
     
      try {

         
          $ticket->delete($id);
         // print_r($ticket->delete($id)); die();
          echo '<script>alert("Ticket deleted successfully");window.location = "./dashboard.php"</script>';
      } catch (Exception $e) {
          echo $e->getMessage();
      }
  
  }
 
?>


<div id="content-wrapper">
  <div class="container-fluid">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="#">New</a></li>
      <li class="breadcrumb-item active">Overview</li>
    </ol>

    <div class="card mb-3">
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-bordered table-sm" id="dataTable" width="100%" cellspacing="0">
            <thead>
              <tr>
                <th class="nowrap" style="width: 80px;">Ticket ID</th>
                <th class="nowrap" style="width: 120px;">Name</th>
                <th class="nowrap" style="width: 160px;">Email</th>
                <th class="nowrap" style="width: 120px;">Phone</th>
                <th class="nowrap" style="width: 120px;">Issue Type</th>
                <th style="width: 200px;">Description</th>
                <th class="nowrap" style="width: 90px;">Priority</th>
                <th class="nowrap" style="width: 90px;">Status</th>
                <th class="nowrap" style="width: 130px;">Created At</th>
                <th class="nowrap" style="width: 70px;">Action</th>
              </tr>
            </thead>

            <tbody>
              <?php foreach($allTicket as $ticket): ?>
              <tr>
                <td class="nowrap"><?= $ticket->ticket_id; ?></td>
                <td class="nowrap"><?= $ticket->user_name; ?></td>
                <td class="nowrap"><?= $ticket->user_email; ?></td>
                <td class="nowrap"><?= $ticket->user_phone; ?></td>
                <td class="nowrap"><?= $ticket->issue_type; ?></td>
                <td class="wrap-description"><?= $ticket->description; ?></td>

                <!-- Priority Button -->
                <td class="nowrap">
                  <?php
                  $priorityLabels = ['0' => 'Low', '1' => 'Medium', '2' => 'High'];
                  $priorityClass = ['0' => 'btn-secondary', '1' => 'btn-primary', '2' => 'btn-danger'];
                  $btnClass = $priorityClass[$ticket->priority] ?? 'btn-light';
                  $label = $priorityLabels[$ticket->priority] ?? 'Unknown';
                  ?>
                  <button class="btn-sm px-1 py-0 <?= $btnClass ?>"><?= $label ?></button>
                </td>

                <!-- Status Button -->
                <td class="nowrap">
                 
                  <button class="btn btn-sm px-1 py-0 btn-danger">New</button>
                </td>

                <td class="nowrap"><?= $ticket->created_at; ?></td>

                <td class="nowrap">
                  <a class="btn btn-xs btn-outline-danger"
                     onclick="return confirm('Are you sure you want to delete this ticket?')"
                     href="?del=<?= $ticket->id; ?>">
                    Delete
                  </a>
                </td>
              </tr>
              <?php endforeach ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>  <!-- /.container-fluid -->

  <!-- Sticky Footer -->
  <footer class="sticky-footer">
    <div class="container my-auto">
      <div class="copyright text-center my-auto">
        <span>Copyright © synchlab coding</span>
      </div>
    </div>
  </footer>

</div>
<!-- /.content-wrapper -->

</div>
<!-- /#wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
  <i class="fas fa-angle-up"></i>
</a>

<!-- Logout Modal-->
<div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
  aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">×</span>
        </button>
      </div>
      <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
        <a class="btn btn-primary" href="./index.php">Logout</a>
      </div>
    </div>
  </div>
</div>

<!-- Bootstrap core JavaScript-->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

<!-- Core plugin JavaScript-->
<script src="vendor/jquery-easing/jquery.easing.min.js"></script>

<!-- Page level plugin JavaScript-->
<script src="vendor/chart.js/Chart.min.js"></script>
<script src="vendor/datatables/jquery.dataTables.js"></script>
<script src="vendor/datatables/dataTables.bootstrap4.js"></script>

<!-- Custom scripts for all pages-->
<script src="js/sb-admin.min.js"></script>

<!-- Demo scripts for this page-->
<script src="js/demo/datatables-demo.js"></script>
<script src="js/demo/chart-area-demo.js"></script>

</body>

</html>