<?php
  

  include './header.php';
require_once './src/Database.php';
require './src/user.php';
require './src/helper-functions.php';

  $err = '';
  $msg = '';
  
  if (isset($_POST['submit'])) {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $password = $_POST['password'];
    $confirm_pass = $_POST['confirm-password'];
    $bitrixUserId  = $_POST['bitrix_user'] ?? null;
    $responsibleId = $_POST['responsible_id'] ?? null;
    $folderId      = $_POST['folder_id'] ?? null; 
    $projectId     = $_POST['project_id'] ?? null;

    if (strlen($name) < 1) {
        $err = "Please enter user name";
    } else if (strlen($email) < 1) {
        $err = "Please enter email";
    } else if (!isValidEmail($email)) {
        $err = "Please enter a valid email";
    } else if (strlen($phone) < 1) {
        $err = "Please enter phone number";
    } else if (!isValidPhone($phone)) {
        $err = "Please enter a valid phone number";
    } else if (strlen($password) < 1) {
        $err = "Please enter a password";
    } else if (strlen($password) < 8) {
        $err = "Password should be at least 8 characters";
    } else if ($password != $confirm_pass) {
        $err = "Passwords do not match";
    } else {
        try {
            $user = new User([
                'name' => $name,
                'email' => $email,
                'phone' => $phone,
                'bitrix24_user_id' => $bitrixUserId,
                'project_id' => $projectId,
                'folder_id' => $folderId,
                'password' => password_hash($password, PASSWORD_DEFAULT),
                'last_password' => password_hash($password, PASSWORD_DEFAULT),
                'role' => 'member'
            ]);

            $data = $user->save(); 
            $msg = "User created successfully!";
        } catch (Exception $e) {
            $err = "Unable to create user: " . $e->getMessage();
        }
    }
}
$bitrixUserId  = $_GET['bitrix_user'] ?? '';
$projectId     = $_GET['project_id'] ?? '';
$folderId      = $_GET['folder_id'] ?? '';

 ?>
<div id="content-wrapper">

    <div class="container-fluid">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="#">Dashboard</a>
            </li>
            <li class="breadcrumb-item active">New ticket</li>
        </ol>

        <div class="card mb-3">
            <div class="card-header">
                <h3>Create a new ticket</h3>
            </div>
            <div class="card-body">
               
              <?php if(strlen($err) > 1) :?>
                <div class="alert alert-danger text-center my-3" role="alert"> <strong>Failed! </strong> <?php echo $err;?></div>
                <?php endif?>

                <?php if(strlen($msg) > 1) :?>
                <div class="alert alert-success text-center my-3" role="alert"> <strong>Success! </strong> <?php echo $msg;?></div>
                <?php endif?>

                <form method="POST" action="<?php echo $_SERVER['PHP_SELF']?>">
                <input type="hidden" name="bitrix_user" value="<?php echo $bitrixUserId; ?>">
                <input type="hidden" name="project_id" value="<?php echo $projectId; ?>">
                <input type="hidden" name="folder_id" value="<?php echo $folderId; ?>">
                    <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                        <label for="name" class="col-sm-12 col-lg-2 col-md-2 col-form-label">Name</label>
                        <div class="col-sm-8">
                            <input type="text" name="name" class="form-control" id="" placeholder="Enter name">
                        </div>
                    </div>
                    <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                        <label for="email" class="col-sm-12 col-lg-2 col-md-2 col-form-label">Email</label>
                        <div class="col-sm-8">
                            <input type="text" name="email" class="form-control" id="" placeholder="Enter email">
                        </div>
                    </div>
                    <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                        <label for="email" class="col-sm-12 col-lg-2 col-md-2 col-form-label">Phone</label>
                        <div class="col-sm-8">
                            <input type="text" name="phone" class="form-control" id="" placeholder="Enter phone number">
                        </div>
                    </div>
                 
                   
                 
                    <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                        <label for="email" class="col-sm-12 col-lg-2 col-md-2 col-form-label">Password</label>
                        <div class="col-sm-8">
                            <input type="password" name="password" class="form-control" id="" placeholder="Enter password">
                        </div>
                    </div>
                    <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                        <label for="email" class="col-sm-12 col-lg-2 col-md-2 col-form-label">Confirm Password </label>
                        <div class="col-sm-8">
                            <input type="password" name="confirm-password" class="form-control" id="" placeholder="Enter confirm password">
                        </div>
                    </div>
                 
                 
                   
                    <div class="text-center">
                        <button type="submit" name="submit" class="btn btn-lg btn-primary"> Create</button>
                    </div>
                </form>
            </div>
        </div>

    </div>
    <!-- /.container-fluid -->

    <!-- Sticky Footer -->
    <footer class="sticky-footer">
        <div class="container my-auto">
            <div class="copyright text-center my-auto">
            <span>Copyright © Synchlab Coding</span>
            </div>
        </div>
    </footer>

</div>
<!-- /.content-wrapper -->

</div>
<!-- /#wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>

<!-- Logout Modal-->
<div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
            <div class="modal-footer">
                <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                <a class="btn btn-primary" href="./index.php">Logout</a>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap core JavaScript-->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

<!-- Core plugin JavaScript-->
<script src="vendor/jquery-easing/jquery.easing.min.js"></script>

<!-- Page level plugin JavaScript-->
<script src="vendor/chart.js/Chart.min.js"></script>
<script src="vendor/datatables/jquery.dataTables.js"></script>
<script src="vendor/datatables/dataTables.bootstrap4.js"></script>

<!-- Custom scripts for all pages-->
<script src="js/sb-admin.min.js"></script>

<!-- Demo scripts for this page-->
<script src="js/demo/datatables-demo.js"></script>
<script src="js/demo/chart-area-demo.js"></script>

</body>

</html>