<?php
session_set_cookie_params([
    'lifetime' => 0,
    'path' => '/',
    'domain' => '.' . $_SERVER['HTTP_HOST'],  // Dynamic domain fetch karna
    'secure' => true,
    'httponly' => true,
    'samesite' => 'None'
  ]);
  session_start();
include './header.php';
/*require_once './src/ticket.php';
require_once './src/requester.php';
require_once './src/team.php';
require_once './src/user.php';*/
$bitrix24UserId      = isset($_SESSION['bitrix_user_id']) && !empty($_SESSION['bitrix_user_id']) ? $_SESSION['bitrix_user_id'] : null;


$tickets = Ticket::findByMember($user->id);

?>
<div id="content-wrapper">

    <div class="container-fluid">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="#">Dashboard</a>
            </li>
            <li class="breadcrumb-item active">My tickets</li>
        </ol>
        <div class="card mb-3">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Subject</th>
                                <th>Requester</th>
                                <th>Team</th>
                                <th>Agent</th>
                                <th>Requested</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($tickets as $ticket) : ?>
                                <tr>
                                    <td><a href="./ticket-details.php?id=<?php echo $ticket->id ?>"><?php echo $ticket->title ?></a>
                                    </td>
                                    <td><?php echo Requester::find($ticket->requester)->name ?></td>
                                    <td><?php echo Team::find($ticket->team)->name; ?></td>
                                    <?php $usr =  $ticket->team_member ?>
                                    <?php if ($usr == '') : ?>
                                        <td><?php echo $usr ?></td>
                                    <?php endif; ?>
                                    <?php if ($ticket->status == 'solved') : ?>
                                        <td>
                                            <button class="btn btn-success"><?php echo $ticket->status ?></button>
                                        </td>
                                  
                                    <?php else : ?>
                                        <td>
                                            <button class="btn btn-warning"><?php echo $ticket->status ?></button>
                                        </td>
                                    <?php endif; ?>
                                    <?php $date = new DateTime($ticket->created_at) ?>
                                    <td><?php echo $date->format('d-m-Y H:i:s') ?> </td>
                                    <td width="100px">
                                        <div class="btn-group" role="group" aria-label="Button group with nested dropdown">
                                            <div class="btn-group" role="group">
                                                <button id="btnGroupDrop1" type="button" class="btn btn-outline-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    Action
                                                </button>
                                                <div class="dropdown-menu" aria-labelledby="btnGroupDrop1">
                                                    <a class="dropdown-item" href="./ticket-details.php?id=<?php echo $ticket->id ?>">View</a>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
    <!-- /.container-fluid -->

    <!-- Sticky Footer -->
    <footer class="sticky-footer">
        <div class="container my-auto">
            <div class="copyright text-center my-auto">
                <span>Copyright © Synchlab Coding</span>
            </div>
        </div>
    </footer>

</div>
<!-- /.content-wrapper -->

</div>
<!-- /#wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>


<!-- Bootstrap core JavaScript-->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

<!-- Core plugin JavaScript-->
<script src="vendor/jquery-easing/jquery.easing.min.js"></script>

<!-- Page level plugin JavaScript-->
<script src="vendor/chart.js/Chart.min.js"></script>
<script src="vendor/datatables/jquery.dataTables.js"></script>
<script src="vendor/datatables/dataTables.bootstrap4.js"></script>

<!-- Custom scripts for all pages-->
<script src="js/sb-admin.min.js"></script>

<!-- Demo scripts for this page-->
<script src="js/demo/datatables-demo.js"></script>
<script src="js/demo/chart-area-demo.js"></script>

</body>

</html>