<?php
session_set_cookie_params([
    'lifetime' => 0,
    'path' => '/',
    'domain' => '.' . $_SERVER['HTTP_HOST'],
    'secure' => true,
    'httponly' => true,
    'samesite' => 'None'
]);
session_start();

include './header.php';
require_once './src/Database.php';
$conn = Database::getInstance();

$bitrix24UserId = isset($_SESSION['bitrix_user_id']) && !empty($_SESSION['bitrix_user_id']) ? $_SESSION['bitrix_user_id'] : null;
?>

<div id="content-wrapper">
  <div class="container-fluid">
   
<div class="d-flex justify-content-between align-items-center p-2 mb-3 rounded hedding-content">
      <!-- Left side (Breadcrumb) -->
      <div>
        <a href="#">Webhooks</a>
        <span class="mx-2">/</span>
        <strong>All webhook</strong>
      </div>

    </div>
    <div class="container mt-5">
      <div class="row justify-content-center">
        <div class="col-md-6">

          <?php
          $urls = [
            'Add This Url Bitrix24 Outbond Webhook' => "https://integrations.notamedia.co.in/helpdesk-core-php/ticket-user/email_comment_add.php?user_id=$bitrix24UserId",
            'Add This Url Bitrix24 Outbond Webhook' => "https://integrations.notamedia.co.in/helpdesk-core-php/ticket-user/email_ticket_handler.php?user_id=$bitrix24UserId",
            'Send this link Your client' => "https://integrations.notamedia.co.in/helpdesk-core-php/ticket-user/"
          ];

          $index = 1;
          foreach ($urls as $label => $url): ?>
            <div class="mb-4 text-center">
              <label class="fw-bold d-block mb-2"><?= $label ?></label>
              <div class="input-group mx-auto" style="max-width: 500px;">
                <input type="text" class="form-control form-control-sm readonly-input" id="copyInput<?= $index ?>" value="<?= $url ?>" readonly>
                <button class="btn btn-success btn-sm copy-btn" type="button" data-input="copyInput<?= $index ?>">Copy</button>
              </div>
            </div>
          <?php $index++; endforeach; ?>

        </div>
      </div>
    </div>
  </div>
</div>

<?php include("footer.php"); ?>

<style>
  .readonly-input {
    font-size: 0.85rem;
    background-color: #f9f9f9;
    cursor: default;
  }

  .copy-btn {
    min-width: 60px;
  }

  .input-group input {
    max-width: 400px;
  }
</style>

<script>
  document.querySelectorAll('.copy-btn').forEach(btn => {
    btn.addEventListener('click', function () {
      const inputId = this.dataset.input;
      const input = document.getElementById(inputId);
      input.select();
      input.setSelectionRange(0, 99999);
      document.execCommand("copy");

      this.textContent = "Copied!";
      this.classList.remove("btn-success");
      this.classList.add("btn-secondary");

      setTimeout(() => {
        this.textContent = "Copy";
        this.classList.remove("btn-secondary");
        this.classList.add("btn-success");
      }, 2000);
    });
  });
</script>
