<?php
require_once '../src/InternalTicket.php';
$projectsType = InternalTicket::getEternalProjects(10);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>New Task Create </title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
    html, body {
      height: 100%;
      margin: 0;
      padding: 0;
      background-color: #f5f5f5;
    }
    .container {
      padding: 0;
    }
    .card {
      border-radius: 1rem;
    }
    .form-container {
      max-width: 500px;
      width: 100%;
    }
    .scrollable-form {
      max-height: 100vh;
      overflow-y: auto;
    }
  </style>
</head>
<body>

  <div class="container d-flex justify-content-center align-items-start">
    <div class="card shadow form-container scrollable-form mt-0">
      <div class="card-body p-4">
        <h3 class="card-title text-center mb-4">Clerk Check-In Report</h3>
       <form action="../src/ExternalTicket.php" method="POST" enctype="multipart/form-data">
           <?php foreach ($projectsType as $projectType): ?>
          <input type="hidden" name="issue_type" value="<?= $projectType['project_type'] . '|' . $projectType['project_id'] . '|' . $projectType['folder_id'] . '|' . $projectType['id'] ?>
         ">
        <?php endforeach ?>
<input type="hidden" name="bitrix24_user_id" value="10">
        <div class="mb-3">
          <label class="form-label">Clerk Name </label>
          <input type="text" class="form-control" name="clerk_name" />
        </div>

        <div class="mb-3">
          <label class="form-label">Clerk Email </label>
          <input type="email" class="form-control" name="user_email" />
        </div>

        <div class="mb-3">
          <label class="form-label">Report Type </label>
          <input type="text" class="form-control" name="report_type" />
        </div>

        <div class="mb-3">
          <label class="form-label">Property </label>
          <input type="text" class="form-control" name="subject" />
        </div>

        <div class="mb-3">
          <label class="form-label">Created On </label>
          <input type="datetime-local" class="form-control" name="created_on" />
        </div>

        <div class="mb-3">
          <label class="form-label">Due On </label>
          <input type="datetime-local" class="form-control" name="due_on" />
        </div>

        <div class="mb-3">
          <label class="form-label">Upload Report File </label>
          <input type="file" class="form-control"name="attachment" id="attachment" />
        </div>

        <button type="submit" class="btn btn-primary w-100">Create Task</button>
        </form>
      </div>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
