<?php
// Get the token from URL (sanitize it)
$token = isset($_GET['token']) ? htmlspecialchars(trim($_GET['token'])) : '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Reset Password</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f5f6fa;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      margin: 0;
    }
    .container {
      background: #fff;
      padding: 30px;
      border-radius: 10px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
      width: 100%;
      max-width: 400px;
    }
    h2 {
      text-align: center;
      margin-bottom: 25px;
      color: #333;
    }
    label {
      font-weight: bold;
      margin-bottom: 5px;
      display: block;
    }
    input[type="password"], input[type="hidden"] {
      width: 100%;
      padding: 12px;
      margin-top: 5px;
      margin-bottom: 5px;
      border: 1.5px solid #ccc;
      border-radius: 6px;
      font-size: 16px;
      transition: border-color 0.3s ease;
    }
    input.error {
      border-color: #e74c3c;
    }
    .error-message {
      color: #e74c3c;
      font-size: 0.9rem;
      margin-bottom: 12px;
    }
    .btn {
      width: 100%;
      padding: 14px;
      background-color: #3498db;
      color: white;
      font-weight: bold;
      border: none;
      border-radius: 6px;
      font-size: 16px;
      cursor: pointer;
      margin-top: 10px;
    }
    .btn:hover {
      background-color: #2980b9;
    }
    .logo {
      text-align: center;
      margin-bottom: 20px;
    }
    .logo img {
      width: 180px;
      height: auto;
    }
  </style>
</head>
<body>

<div class="container">
  <div class="logo">
    <img src="../logo/TicketDesk Logo Green.png" alt="Logo">
  </div>
  <h2>Reset Password</h2>

  <form id="resetForm" action="reset-password-submit.php" method="POST" novalidate>
    <!-- Token input -->
    <input type="hidden" name="token" value="<?= $token ?>">

    <label for="new_password">New Password</label>
    <input type="password" id="new_password" name="new_password" required />
    <div class="error-message" id="newPasswordError"></div>

    <label for="confirm_password">Confirm Password</label>
    <input type="password" id="confirm_password" name="confirm_password" required />
    <div class="error-message" id="confirmPasswordError"></div>

    <button type="submit" class="btn">Reset Password</button>
  </form>
</div>

<script>
  const form = document.getElementById('resetForm');
  const newPassword = document.getElementById('new_password');
  const confirmPassword = document.getElementById('confirm_password');
  const newPasswordError = document.getElementById('newPasswordError');
  const confirmPasswordError = document.getElementById('confirmPasswordError');

  form.addEventListener('submit', function(e) {
    let valid = true;

    newPasswordError.textContent = '';
    confirmPasswordError.textContent = '';
    newPassword.classList.remove('error');
    confirmPassword.classList.remove('error');

    const newVal = newPassword.value.trim();
    const confirmVal = confirmPassword.value.trim();

    if (newVal.length < 8) {
      newPasswordError.textContent = 'Password must be at least 8 characters.';
      newPassword.classList.add('error');
      valid = false;
    }

    if (newVal !== confirmVal) {
      confirmPasswordError.textContent = 'Passwords do not match.';
      confirmPassword.classList.add('error');
      valid = false;
    }

    if (!valid) e.preventDefault();
  });
</script>

</body>
</html>
