<?php
include("user_header.php");
$taskId = $_GET['task_id'];
$bitrix24User = $_GET['btrix24_user'];
?>
<style>
        body {
            background: linear-gradient(to right, #e0eafc, #cfdef3);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
        }

        .block {
            max-width: 700px;
            margin: 100px auto 100px;
            background: #ffffff;
            border-radius: 16px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: column;
            height: calc(100vh - 200px);
            overflow: hidden;
        }

        .title {
            padding: 20px 25px 10px;
            border-bottom: 1px solid #eee;
        }

        .title h2 {
            font-size: 22px;
            font-weight: 600;
            margin: 0;
            color: #333;
        }

        .comment-box {
            flex: 1;
            overflow-y: auto;
            padding: 20px;
            background: #f9f9f9;
        }

        .comment {
            margin-bottom: 15px;
            display: flex;
            justify-content: flex-start;
        }

        .comment .content {
            background-color: #d4edff;
            border-radius: 15px 15px 15px 0;
            padding: 15px;
            max-width: 75%;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
        }

        .post_msg {
            font-size: 15px;
            color: #333;
            margin-bottom: 8px;
        }

        .meta-row {
            font-size: 12px;
            color: #777;
            display: flex;
            justify-content: space-between;
        }

        .comment .content img {
            max-width: 100%;
            border-radius: 12px;
            margin-top: 10px;
        }

        .input-area {
            border-top: 1px solid #ddd;
            padding: 15px 20px;
            background: #fff;
        }

        .textarea {
            width: 100%;
            min-height: 80px;
            padding: 10px 15px;
            border-radius: 12px;
            background-color: #f2f2f2;
            border: 1px solid #ccc;
            font-size: 15px;
            resize: none;
            outline: none;
        }

        .textarea:focus {
            border-color: #5b9bd5;
            box-shadow: 0 0 5px rgba(91, 155, 213, 0.3);
        }

        .file-upload {
            font-size: 13px;
            margin-top: 8px;
        }

        .send-btn {
            background-color: #007bff;
            color: #fff;
            padding: 8px 16px;
            border: none;
            border-radius: 8px;
            margin-top: 10px;
            float: right;
            transition: background 0.3s ease;
        }

        .send-btn:hover {
            background-color: #0056b3;
        }

    </style>
</head>
<body>

<div class="block">
    <!-- Title -->
    <div class="title">
        <h2>Comments</h2>
    </div>

    <!-- Comments Area -->
    <div class="comment-box" id="yourCommentContainer">
        <!-- Dynamic Comments will load here -->
    </div>

    <!-- Input Area -->
    <div class="input-area">
        <form id="commentForm">
            <div>
                <textarea id="comment" class="textarea" placeholder="Type your message..."></textarea>
            </div>
            <input type="file" id="file-upload" class="file-upload" name="file-upload">
            <button type="submit" class="send-btn">Send</button>
        </form>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script>
function formatDate(dateStr) {
    const date = new Date(dateStr);
    return date.toLocaleString('en-US', {
        month: 'short',
        day: 'numeric',
        year: 'numeric',
        hour: 'numeric',
        minute: '2-digit',
        hour12: true
    });
}

$(document).ready(function() {
    let taskId = "<?= $taskId ?>";
    let bitrix24Id = "<?= $bitrix24User ?>";

    // Submit comment
    $("#commentForm").on("submit", function(e) {
        e.preventDefault();

        let commentValue = $("#comment").val().trim();
        if (commentValue === "") {
            alert("Please enter a comment.");
            return;
        }

        $.ajax({
            url: 'comment_get_api.php',
            type: 'POST',
            data: {
                taskId: taskId,
                commentValue: commentValue,
                bitrix24Id: bitrix24Id    
            },
            success: function(response) {
                $("#comment").val('');
                loadComments();
            },
            error: function(xhr, status, error) {
                console.error('POST Error:', error);
            }
        });
    });

    // Load comments
    function loadComments() {
        $.ajax({
            url: 'comment_get_api.php',
            type: 'GET',
            data: {
                taskId: taskId,
                bitrix24Id: bitrix24Id    
            },
            dataType: 'json',
            success: function(response) {
                $('#yourCommentContainer').empty();
                if (response.result && Array.isArray(response.result)) {
                    response.result.forEach(function(comment) {
                        const postMessage = comment.POST_MESSAGE || '';
                        const postDateRaw = comment.POST_DATE || '';
                        const formattedDate = formatDate(postDateRaw);

                        let contentHtml = '';
                        if (postMessage.match(/\.(jpeg|jpg|png|gif)$/i)) {
                            contentHtml = `<img src="${postMessage}" alt="image-comment">`;
                        } else {
                            contentHtml = `<p class="post_msg">${postMessage}</p>`;
                        }

                        const commentHTML = `
                            <div class="comment">
                                <div class="content">
                                    ${contentHtml}
                                    <div class="meta-row">
                                        <span>${formattedDate}</span>
                                    </div>
                                </div>
                            </div>
                        `;
                        $('#yourCommentContainer').append(commentHTML);
                    });

                    $('#yourCommentContainer').scrollTop($('#yourCommentContainer')[0].scrollHeight);
                } else {
                    $('#yourCommentContainer').html('<p class="text-muted">No comments yet.</p>');
                }
            },
            error: function(xhr, status, error) {
                console.error('GET Error:', error);
            }
        });
    }

    loadComments(); // Initial load
});
</script>

</body>
</html>
