<?php
include './header.php';
require_once './src/Database.php';
require './src/user.php';
require './src/helper-functions.php';
require_once __DIR__ . '/./PHPMailer-master/send-mail.php';

$err = '';
$msg = '';

if (isset($_POST['submit'])) {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $password = $_POST['password'];
    $confirm_pass = $_POST['confirm-password'];
    $bitrixUserId  = $_POST['bitrix_user'] ?? null;
    $responsibleId = $_POST['responsible_id'] ?? null;
    $folderId      = $_POST['folder_id'] ?? null;
    $projectId     = $_POST['project_id'] ?? null;

    if (strlen($name) < 1) {
        $err = "Please enter user name";
    } else if (strlen($email) < 1) {
        $err = "Please enter email";
    } else if (!isValidEmail($email)) {
        $err = "Please enter a valid email";
    } else if (strlen($phone) < 1) {
        $err = "Please enter phone number";
    } else if (!isValidPhone($phone)) {
        $err = "Please enter a valid phone number";
    } else if (strlen($password) < 1) {
        $err = "Please enter a password";
    } else if (strlen($password) < 8) {
        $err = "Password should be at least 8 characters";
    } else if ($password != $confirm_pass) {
        $err = "Passwords do not match";
    } else {
        try {
            $user = new User([
                'name' => $name,
                'email' => $email,
                'phone' => $phone,
                'bitrix24_user_id' => $bitrixUserId,
                'project_id' => $projectId,
                'folder_id' => $folderId,
                'password' => password_hash($password, PASSWORD_DEFAULT),
                'last_password' => password_hash($password, PASSWORD_DEFAULT),
                'role' => 'member'
            ]);

            $data = $user->save();
            $msg = "User created successfully!";

            // ✅ Send email
            $subject = "TicketDesk24 Password";
            $body = "
                <p>Hello <strong>" . htmlspecialchars($name) . "</strong>,</p>
                <p>Your TicketDesk24 account has been created successfully.</p>
                <p><strong>Username:</strong> " . htmlspecialchars($email) . "</p>
                <p><strong>Password:</strong> " . htmlspecialchars($password) . "</p>
                <p>Please keep this information secure.</p>
                <br>
                <p><a href='https://integrations.notamedia.co.in/helpdesk-core-php/ticket-user/login-reg.php'>Click here to login</a></p>
                <br><hr>
                <p style='font-size: 0.9rem; color: #888;'>This is an automated message. Please do not reply.</p>
            ";

            sendMail($email, $name, $subject, $body);

        } catch (Exception $e) {
            $err = "Unable to create user: " . $e->getMessage();
        }
    }
}

$bitrixUserId  = $_GET['bitrix_user'] ?? '';
$projectId     = $_GET['project_id'] ?? '';
$folderId      = $_GET['folder_id'] ?? '';
?>

<!-- HTML and form part below remains the same -->
<!-- No changes made here -->

<div class="container-fluid main-content">
    <div class="d-flex justify-content-between align-items-center p-2 mb-3 rounded hedding-content">
        <div>
            <a href="#">Create user</a>
            <span class="mx-2">/</span>
            <strong>Form</strong>
        </div>
    </div>

    <div class="card mb-3">
        <div class="card-header">
            <h3>Create a new user</h3>
        </div>
        <div class="card-body">

            <?php if (strlen($err) > 1) : ?>
                <div class="alert alert-danger alert-dismissible fade show text-center my-3" role="alert">
                    <strong>Failed! </strong> <?php echo $err; ?>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif ?>

            <?php if (strlen($msg) > 1) : ?>
                <div class="alert alert-success alert-dismissible fade show text-center my-3" role="alert">
                    <strong>Success! </strong> <?php echo $msg; ?>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif ?>

            <form method="POST" action="<?php echo $_SERVER['PHP_SELF'] ?>">
                <input type="hidden" name="bitrix_user" value="<?php echo $bitrixUserId; ?>">
                <input type="hidden" name="project_id" value="<?php echo $projectId; ?>">
                <input type="hidden" name="folder_id" value="<?php echo $folderId; ?>">

                <!-- Form Fields -->
                <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                    <label class="col-sm-12 col-lg-2 col-md-2 col-form-label">Name</label>
                    <div class="col-sm-8">
                        <input type="text" name="name" class="form-control" placeholder="Enter name">
                    </div>
                </div>
                <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                    <label class="col-sm-12 col-lg-2 col-md-2 col-form-label">Email</label>
                    <div class="col-sm-8">
                        <input type="text" name="email" class="form-control" placeholder="Enter email">
                    </div>
                </div>
                <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                    <label class="col-sm-12 col-lg-2 col-md-2 col-form-label">Phone</label>
                    <div class="col-sm-8">
                        <input type="text" name="phone" class="form-control" placeholder="Enter phone number">
                    </div>
                </div>
                <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                    <label class="col-sm-12 col-lg-2 col-md-2 col-form-label">Password</label>
                    <div class="col-sm-8">
                        <input type="password" name="password" class="form-control" placeholder="Enter password">
                    </div>
                </div>
                <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                    <label class="col-sm-12 col-lg-2 col-md-2 col-form-label">Confirm Password</label>
                    <div class="col-sm-8">
                        <input type="password" name="confirm-password" class="form-control" placeholder="Enter confirm password">
                    </div>
                </div>
                <div class="text-center">
                    <button type="submit" name="submit" class="btn btn-lg btn-success"> Create</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include("footer.php"); ?>
