<?php
session_set_cookie_params([
  'lifetime' => 0,
  'path' => '/',
  'domain' => '.' . $_SERVER['HTTP_HOST'],
  'secure' => true,
  'httponly' => true,
  'samesite' => 'None'
]);
session_start();
include './header.php';
require_once './src/Database.php';
require_once './src/user.php';
require_once './src/AccessToken.php';
require_once './src/team.php';
require_once './src/InternalTicket.php';

$bitrix24UserId = isset($_SESSION['bitrix_user_id']) && !empty($_SESSION['bitrix_user_id']) ? $_SESSION['bitrix_user_id'] : null;

$userInfo = InternalTicket::getCurrentUser($bitrix24UserId);

//print_r($userInfo);
$userFname = $userInfo['NAME'] . " " . $userInfo['LAST_NAME'];
$userEmail = $userInfo['EMAIL'];
$userId = $userInfo['ID'];

$projectsType = InternalTicket::getInternalProjects($bitrix24UserId);



?>
<div class="container mt-5">

  <div class="row">
    <div class="col-6 offset-3">
      <h3 class="mb-4">Create New Ticket</h3>

      <form action="./src/TicketHandler.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="userName" value="<?= $userFname ?>">
        <input type="hidden" name="created_by" value="<?= $userId ?>">
        <input type="hidden" name="userEmail" value="<?= $userEmail ?>">
        <input type="hidden" name="bitrix24_user_id" value="<?= $bitrix24UserId ?>">
        <div class="form-group">
          <label for="ticketName">Ticket Subject</label>
          <input type="text" class="form-control" id="ticketName" name="ticket_name" required>
        </div>

        <div class="form-group">
          <label for="issueType">Issue Type</label>
          <select class="form-control" id="issueType" name="issue_type" required>
            <option value="">-- Select Issue Type --</option>
            <?php foreach ($projectsType as $projectType): ?>
              <option value="<?= $projectType['project_type'] . '|' . $projectType['project_id'] . '|' . $projectType['folder_id'] . '|' . $projectType['id'] ?>">
                <?= $projectType['project_type'] ?>
              </option>
            <?php endforeach ?>
          </select>
        </div>

        <div class="form-group">
          <label for="priority">Priority</label>
          <select class="form-control" id="priority" name="priority" required>
            <option value="">-- Select Priority --</option>
            <option value="High">High</option>
            <option value="Medium">Medium</option>
            <option value="Low">Low</option>
          </select>
        </div>

        <div class="form-group">
          <label for="comment">Comment</label>
          <textarea class="form-control" id="comment" name="comment" rows="4" required></textarea>
        </div>

        <div class="form-group">
          <label for="fileUpload">Attach File (optional)</label>
          <input type="file" class="form-control-file" id="fileUpload" name="attachment">
        </div>

        <button type="submit" class="btn btn-success">Create Ticket</button>
      </form>
    </div>
  </div>
</div>
<!-- Bootstrap core JavaScript-->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

<!-- Core plugin JavaScript-->
<script src="vendor/jquery-easing/jquery.easing.min.js"></script>

<!-- Page level plugin JavaScript-->
<script src="vendor/chart.js/Chart.min.js"></script>
<script src="vendor/datatables/jquery.dataTables.js"></script>
<script src="vendor/datatables/dataTables.bootstrap4.js"></script>

<!-- Custom scripts for all pages-->
<script src="js/sb-admin.min.js"></script>

<!-- Demo scripts for this page-->
<script src="js/demo/datatables-demo.js"></script>
<script src="js/demo/chart-area-demo.js"></script>

</body>

</html>