<?php
include './header.php';
require_once './src/Database.php';
require './src/user.php';
require './src/helper-functions.php';
require_once __DIR__ . '/./PHPMailer-master/send-mail.php';


$err = '';
$msg = '';
$userId = $_GET['user_id'];

// Fetch the user data based on the user_id
$user = User::find($userId); // Assuming the find method fetches user details
 
if ($user) {
    $user = $user; // Assuming find() returns an array of users, take the first one
} else {
    $err = "User not found!";
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get the form data
    $name = $_POST['name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $password = $_POST['password'];
    $confirm_pass = $_POST['confirm-password'];

    // Validation
    if (strlen($name) < 1) {
        $err = "Please enter user name";
    } else if (strlen($email) < 1) {
        $err = "Please enter email";
    } else if (!isValidEmail($email)) {
        $err = "Please enter a valid email";
    } else if (strlen($phone) < 1) {
        $err = "Please enter phone number";
    } else if (!isValidPhone($phone)) {
        $err = "Please enter a valid phone number";
    } else if (strlen($password) > 0 && $password != $confirm_pass) {
        $err = "Passwords do not match";
    } else {
        try {
            // If password is updated, hash it
            if (strlen($password) > 0) {
                $password = password_hash($password, PASSWORD_DEFAULT);
            } else {
                // Keep the old password if no update
                $password = $user->password;
            }

            // Update user information
            $user->name = $name;
            $user->email = $email;
            $user->phone = $phone;
            $user->password = $password;

            $data = $user->update(); // Assuming the User class has an update method
            $msg = "User updated successfully!";
             $subject = "TicketDesk24 Password";
            $body = "
                <p>Hello <strong>" . htmlspecialchars($name) . "</strong>,</p>
                <p>Your TicketDesk24 account has been created successfully.</p>
                <p><strong>Username:</strong> " . htmlspecialchars($email) . "</p>
                <p><strong>Password:</strong> " . htmlspecialchars($confirm_pass) . "</p>
                <p>Please keep this information secure.</p>
                <br>
                <p><a href='https://integrations.notamedia.co.in/helpdesk-core-php/ticket-user/login-reg.php'>Click here to login</a></p>
                <br><hr>
                <p style='font-size: 0.9rem; color: #888;'>This is an automated message. Please do not reply.</p>
            ";

            sendMail($email, $name, $subject, $body);
        } catch (Exception $e) {
            $err = "Unable to update user: " . $e->getMessage();
        }
    }
}
?>

<div class="container-fluid main-content">
    <div class="d-flex justify-content-between align-items-center p-2 mb-3 rounded hedding-content">
        <div>
            <a href="#">Edit User</a>
            <span class="mx-2">/</span>
            <strong>Form</strong>
        </div>
    </div>
        <div class="card mb-3">
            <div class="card-header">
                <h3>Edit User</h3>
            </div>
            <div class="card-body">
                <?php if(strlen($err) > 1) :?>
                <div class="alert alert-danger text-center my-3" role="alert"> <strong>Failed! </strong> <?php echo $err;?></div>
                <?php endif?>

                <?php if(strlen($msg) > 1) :?>
                <div class="alert alert-success text-center my-3" role="alert"> <strong>Success! </strong> <?php echo $msg;?></div>
                <?php endif?>

                <form method="POST" action="<?php echo $_SERVER['PHP_SELF'] . '?user_id=' . $userId; ?>">

                    <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                        <label for="name" class="col-sm-12 col-lg-2 col-md-2 col-form-label">Name</label>
                        <div class="col-sm-8">
                            <input type="text" name="name" class="form-control" value="<?php echo $user->name; ?>" placeholder="Enter name">
                        </div>
                    </div>
                    <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                        <label for="email" class="col-sm-12 col-lg-2 col-md-2 col-form-label">Email</label>
                        <div class="col-sm-8">
                            <input type="email" name="email" class="form-control" value="<?php echo $user->email; ?>" placeholder="Enter email">
                        </div>
                    </div>
                    <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                        <label for="phone" class="col-sm-12 col-lg-2 col-md-2 col-form-label">Phone</label>
                        <div class="col-sm-8">
                            <input type="text" name="phone" class="form-control" value="<?php echo $user->phone; ?>" placeholder="Enter phone number">
                        </div>
                    </div>

                    <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                        <label for="password" class="col-sm-12 col-lg-2 col-md-2 col-form-label">Password</label>
                        <div class="col-sm-8">
                            <input type="password" name="password" class="form-control" placeholder="Enter new password (leave blank to keep current)">
                        </div>
                    </div>
                    <div class="form-group row col-lg-8 offset-lg-2 col-md-8 offset-md-2 col-sm-12">
                        <label for="confirm-password" class="col-sm-12 col-lg-2 col-md-2 col-form-label">Confirm Password</label>
                        <div class="col-sm-8">
                            <input type="password" name="confirm-password" class="form-control" placeholder="Confirm new password">
                        </div>
                    </div>

                    <div class="text-center">
                        <button type="submit" name="submit" class="btn btn-lg btn-success" >Update User</button>
                    </div>
                </form>
            </div>
        </div>

    </div>
    <?php include("footer.php");?>
